/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.uri.MoveURIThread;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Requires(group=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class MoveURI
implements Generator,
MultipleCheck {
    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) throws DatabaseException {
        String commentgroups;
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        URI uri = req.getURI();
        if (URIs.isExternal((URI)uri)) {
            return Collections.singletonList(new ForbiddenCheck());
        }
        if (URIRule.isFolder((URI)uri)) {
            Collection guris = DatabaseQuery.getGroupURIsBySchemeHostPortSuperSubpathCol((Database)req.getDatabase(), (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)uri.getPath(), (boolean)true, (boolean)true);
            for (GroupURI gu : guris) {
                if (!GroupURIRule.isShared((Database)req.getDatabase(), (GroupURI)gu)) continue;
                checks.add((PermissionCheck)new ConfigureProjectCheck(URIRule.getDefaultGroupForURI((URI)uri)));
            }
        }
        checks.add((PermissionCheck)new EditURICheck(req.getGroup(), uri));
        long id = req.getParameter((Parameter)StandardParameters.destination_uri, -1L);
        if (id != -1L) {
            checks.add((PermissionCheck)new EditURICheck(DatabaseQuery.getURIById((Database)req.getDatabase(), (Long)id)));
        }
        if ((id = req.getParameter((Parameter)StandardParameters.destination_guri, -1L)) != -1L) {
            checks.add((PermissionCheck)new EditURICheck(DatabaseQuery.getGroupURIById((Database)req.getDatabase(), (Long)id)));
        }
        if (!(commentgroups = req.getParameter((Parameter)StandardParameters.comment_groups, "")).isEmpty()) {
            checks.add((PermissionCheck)new EditGroupCheck(req.getGroup()));
        }
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        String newName = req.getParameter((Parameter)StandardParameters.name);
        if (newName != null && newName.charAt(0) == '.') {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.ILLEGAL_FILENAME, "Filename cannot start with a '.'.");
            return;
        }
        URI uri = req.getURI();
        Group grp = req.getGroup();
        Member member = req.getMember();
        Database db = req.getDatabase();
        assert (uri != null && grp != null && member != null);
        Long uriid = uri.getId();
        String group_param = req.getParameter((Parameter)StandardParameters.comment_groups, "");
        ArrayList<String> commentGroups = "".equals(group_param) ? new ArrayList<String>() : Arrays.asList(req.getParameter((Parameter)StandardParameters.comment_groups, "").split(","));
        MoveURIThread thread = MoveURIThread.newInstance(false, member.getUsername(), grp);
        thread.addURIToMove(uriid, newName);
        thread.setCommentGroups(commentGroups);
        thread.setDestinationURIID(req.getParameter((Parameter)StandardParameters.destination_uri, -1L));
        thread.setDestinationGroupURIID(req.getParameter((Parameter)StandardParameters.destination_guri, -1L));
        if ("folder".equals(uri.getType())) {
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            res.setStatus(GeneratorStatus.ACCEPTED);
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("uri-move");
            thread.print((OutputPrinter)out);
            out.endObject();
            out.flush();
        } else {
            ProcessManager manager = ProcessManager.getInstance();
            manager.prepareForStart((ProcessThread)thread, true);
            if (!thread.run(db, req.getTransaction())) {
                res.setError(GeneratorStatus.BAD_REQUEST, thread.getCurrentStatus().getMessage());
                req.getTransaction().abort();
            } else {
                UniversalPrinter out = res.getUniversalWriter();
                out.startObject("uri-move");
                out.field("threadid", thread.getThreadID());
                if (thread.hasWarning()) {
                    out.field("warning", true);
                }
                out.writeURI(DatabaseQuery.getURIById((Database)db, (Long)uriid));
                out.endObject();
                out.flush();
            }
            manager.clearIfFinished(thread.getThreadID());
        }
    }
}

