/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.PageSeederQuery;
import com.pageseeder.search.utils.SearchUtils;
import com.pageseeder.thread.PSMLContentMatchThread;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.slf4j.LoggerFactory;

@Requires(group=true, member=true, parameters={"term", "publicationid"})
@PublicAPI
public final class MatchPSMLContentPublication
implements Generator,
MultipleCheck {
    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) {
        Group group = req.getGroup();
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        checks.add((PermissionCheck)new ViewMemberCheck(req.getMember()));
        checks.add((PermissionCheck)new EditURICheck(group));
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Database db = req.getDatabase();
        Member member = req.getMember();
        Group group = req.getGroup();
        assert (group != null && member != null);
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, group.getName() + " is a project");
            return;
        }
        String pubid = req.getParameter((Parameter)StandardParameters.publicationid);
        assert (pubid != null);
        Publication pub = Publications.getPublicationByPublicationIDGroup((Database)db, (String)pubid, (Group)group);
        if (pub == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Publication not found with ID: " + pubid);
        }
        XLink pubXlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
        String term = req.getParameter((Parameter)StandardParameters.term);
        boolean caseSensitive = req.getParameter("case-sensitive", true);
        boolean isRegex = req.getParameter("regex", false);
        boolean isWord = req.getParameter("word", false);
        assert (term != null);
        PSMLContentMatchThread thread = PSMLContentMatchThread.newInstance(member.getUsername(), group, term);
        thread.setCaseSensitive(caseSensitive);
        thread.setWord(isWord);
        thread.setLiteral(!isRegex);
        thread.setResultAttribute("publicationid", pubid);
        try {
            List<Long> documents = this.canUseIndex(isWord, term) ? this.listMatchingDocuments(db, group, pubid, term) : this.listDocuments(db, group, pubXlink);
            boolean foundOne = false;
            for (Long doc : documents) {
                thread.addURI(doc);
                foundOne = true;
            }
            if (!foundOne) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NO_URIS_TO_PROCESS, "No documents to search!");
                return;
            }
        }
        catch (QueryFailedException | ParseException | IndexException ex) {
            LoggerFactory.getLogger(MatchPSMLContentPublication.class).error("Failed to load documents", ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load documents in publication: " + ex.getMessage());
            return;
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("publication-scan");
        thread.print((OutputPrinter)out);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    private List<Long> listMatchingDocuments(Database db, Group group, String pubid, String searchString) throws ParseException, IndexException {
        Catalog catalog = SearchUtils.getGlobalCatalog();
        GroupIndex index = IndexMaster.getInstance().getIndex(db, group);
        Analyzer analyser = SearchUtils.loadAnalyzer(Collections.singletonList(index), (Group)group);
        PageSeederQuery query = new PageSeederQuery.Builder().catalog(catalog).analyser(analyser).question("\"" + searchString + "\"").defaultField("pscontent").addStringFilter("pstype", "document", BooleanClause.Occur.MUST).addStringFilter("pspublicationid", pubid, BooleanClause.Occur.MUST).build();
        SearchResults results = IndexMaster.getInstance().search(db, group, (SearchQuery)query, 10000, 1);
        ArrayList<Long> ids = new ArrayList<Long>(results.getLastHit());
        for (Document r : results.documents()) {
            ids.add(Long.parseLong(r.getField("psid").stringValue()));
        }
        return ids;
    }

    private List<Long> listDocuments(Database db, Group group, XLink pub_xlink) throws DatabaseException {
        Collection uris = DatabaseQuery.getURIsForPublication((Database)db, (XLink)pub_xlink);
        ArrayList<Long> uriids = new ArrayList<Long>();
        for (URI uri : uris) {
            if (!URIRule.belongsToGroup((Database)db, (Long)uri.getId(), (String)group.getName())) continue;
            uriids.add(uri.getId());
        }
        return uriids;
    }

    boolean canUseIndex(boolean isWord, String searchString) {
        String[] terms;
        if (!isWord || searchString.matches("[^a-z\\s]")) {
            return false;
        }
        for (String term : terms = searchString.split("\\s+")) {
            if (!EnglishAnalyzer.ENGLISH_STOP_WORDS_SET.contains((CharSequence)term)) continue;
            return false;
        }
        return true;
    }
}

