/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Group;
import com.pageseeder.utils.MemberTempFiles;
import java.io.File;
import java.io.IOException;

@Requires(group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListValidations
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        assert (group != null);
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, group.getName() + " is a project");
            return;
        }
        File folder = MemberTempFiles.getTempFolder("shared/validation", group.getName());
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("validations");
        out.startCollection("validations", OutputPrinter.CollectionOption.JSON_ONLY);
        if (folder.exists() && folder.isDirectory()) {
            for (File file : folder.listFiles()) {
                out.startObject("validation");
                out.field("name", file.getName());
                out.field("created", ISO8601.DATETIME.format(file.lastModified()));
                out.endObject();
            }
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

