/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.uri.HistoryEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class History
implements UniversallyPrintable {
    private static final Logger LOGGER = LoggerFactory.getLogger(History.class);
    private static final Comparator<XLink> CHRONOLOGICAL_XLINKS = Comparator.comparing(XLink::getDate);
    private static final int ONE_MINUTE = 60000;
    private final @Nullable URI uri;
    private final @Nullable String folder;
    private final @Nullable String documenttype;
    private final Group group;
    private final @Nullable Member author;
    private final @Nullable Date from;
    private final @Nullable Date to;
    private final @Nullable String label;
    private final @Nullable XLink pubxlink;
    private final Database database;
    private final List<HistoryEvent.EventType> eventTypes = new ArrayList<HistoryEvent.EventType>();
    private final Map<URI, List<XLink>> modifications = new HashMap<URI, List<XLink>>();
    private final Map<URI, List<XLink>> workflows = new HashMap<URI, List<XLink>>();
    private final Map<URI, List<XLink>> versions = new HashMap<URI, List<XLink>>();
    private final Map<Long, Discussion> discussions = new HashMap<Long, Discussion>();
    private @Nullable List<HistoryEvent> events = null;
    private boolean hasMore = false;

    public History(URI u, Group gp, Database db) {
        this.uri = u;
        this.author = null;
        this.from = null;
        this.to = null;
        this.label = null;
        this.folder = null;
        this.documenttype = null;
        this.group = gp;
        this.pubxlink = null;
        this.database = db;
    }

    public History(Member a, Date fd, Date td, String l, String f, String dt, Group gp, XLink pub, Database db) {
        this.uri = null;
        this.author = a;
        this.from = fd;
        this.to = td;
        this.label = l;
        this.folder = f;
        this.documenttype = dt;
        this.group = gp;
        this.pubxlink = pub;
        this.database = db;
    }

    public final void addEventType(@Nullable HistoryEvent.EventType type) {
        if (type != null) {
            this.eventTypes.add(type);
        }
    }

    public final void computeEvents(int page, int pagesize) throws QueryFailedException {
        if (this.eventTypes.isEmpty()) {
            Collections.addAll(this.eventTypes, HistoryEvent.EventType.values());
        }
        List xlinks = DatabaseQuery.getXLinksByURIHistory((Database)this.database, (int)page, (int)pagesize, (boolean)true, (Member)this.author, (String)this.label, (Group)this.group, (Long)(this.uri == null ? null : this.uri.getId()), (String)this.folder, (String)this.documenttype, this.typesAsStrings(), (Date)this.from, (Date)this.to, (XLink)this.pubxlink);
        this.events = new ArrayList<HistoryEvent>();
        HistoryEvent previous = xlinks.isEmpty() ? null : new HistoryEvent((XLink)xlinks.get(xlinks.size() - 1), null, null, null);
        for (int i = Math.min(pagesize, xlinks.size()) - 1; i >= 0; --i) {
            XLink xlink = (XLink)xlinks.get(i);
            HistoryEvent.EventType type = this.findType(xlink);
            if (type != null) {
                HistoryEvent vevent;
                HistoryEvent event;
                String fragment = this.findFragment(xlink);
                previous = event = new HistoryEvent(xlink, fragment, type, previous);
                event.setCanBeMerged((type == HistoryEvent.EventType.CREATION || type == HistoryEvent.EventType.UPLOAD || type == HistoryEvent.EventType.REVERT) && xlink.getType() == null);
                this.findChanges(event);
                if (type != HistoryEvent.EventType.MODIFICATION || event.hasChanges()) {
                    if (type == HistoryEvent.EventType.VERSION) {
                        Collection att = xlink.getAttached();
                        if (att.isEmpty() || !XLinks.isArchived((XLink)((XLinkForAttachedXLink)att.iterator().next()).getAttachedXLink())) {
                            this.events.add(event);
                        }
                    } else {
                        this.events.add(event);
                    }
                }
                if (!"Documentation-Release".equals(xlink.getContentRole()) || xlink.getStatus() == null) continue;
                previous = vevent = new HistoryEvent(xlink, fragment, HistoryEvent.EventType.VERSION, previous);
                this.findChanges(vevent);
                this.events.add(vevent);
                continue;
            }
            LOGGER.warn("Found invalid xlink for URI history event: ", (Object)xlink);
        }
        this.hasMore = xlinks.size() > pagesize;
        Collections.sort(this.events);
    }

    public void print(OutputPrinter out) {
        if (this.events == null) {
            throw new IllegalStateException("Events have not been computed yet");
        }
        out.startObject("history");
        if (this.hasMore) {
            out.field("limitreached", true);
        }
        StringBuilder types = new StringBuilder();
        for (HistoryEvent.EventType type : this.eventTypes) {
            if (types.length() > 0) {
                types.append(',');
            }
            types.append((Object)type);
        }
        out.field("events", types.toString());
        if (this.documenttype != null) {
            out.field("documenttype", this.documenttype);
        }
        if (this.folder != null) {
            out.field("folder", this.folder);
        }
        if (this.label != null) {
            out.field("label", this.label);
        }
        if (this.author != null) {
            out.field("author", this.author.getId().longValue());
        }
        if (this.from != null) {
            out.field("from", ISO8601.DATETIME.format(this.from.getTime()));
        }
        if (this.to != null) {
            out.field("to", ISO8601.DATETIME.format(this.to.getTime()));
        }
        out.startCollection("history", OutputPrinter.CollectionOption.JSON_ONLY);
        for (int i = 0; i < this.events.size(); ++i) {
            HistoryEvent before;
            HistoryEvent event = this.events.get(i);
            HistoryEvent historyEvent = before = i + 1 < this.events.size() ? this.events.get(i + 1) : null;
            if (before != null && before.getType() == HistoryEvent.EventType.MODIFICATION && event.canBeMerged() && (event.getType() == HistoryEvent.EventType.CREATION || event.getType() == HistoryEvent.EventType.UPLOAD && before.getXlink().getDate().getTime() - event.getXlink().getDate().getTime() < 60000L)) {
                HistoryEvent modif = this.events.get(++i);
                event.copyChanges(modif);
            }
            event.print(out, this.database, this.group, this.uri != null ? null : this.findURI(event));
        }
        out.endCollection();
        out.endObject();
    }

    private List<String> typesAsStrings() {
        ArrayList<String> strings = new ArrayList<String>(this.eventTypes.size());
        for (HistoryEvent.EventType type : this.eventTypes) {
            strings.add(type.toString());
        }
        return strings;
    }

    private @Nullable URI findURI(HistoryEvent event) {
        if (this.uri != null) {
            return this.uri;
        }
        XLink xl = event.getXlink();
        if (xl.getUri() != null) {
            return xl.getUri();
        }
        XLink root = XLinks.getThreadRoot((XLink)xl);
        if (root.getUri() != null) {
            return root.getUri();
        }
        for (LocatorForXLink lfx : root.getLocatorsForXLinkCol()) {
            if (!(event.getType() == HistoryEvent.EventType.XREF || event.getType() == HistoryEvent.EventType.IMAGE ? lfx.getRole().startsWith("xref-source") : lfx.getRole() == null && !lfx.getLocator().getURI().getPath().contains("/servlet/com.pageseeder.general/"))) continue;
            return lfx.getLocator().getURI();
        }
        LOGGER.debug("Found null URI for history event {}", (Object)event);
        return null;
    }

    private @Nullable String findFragment(XLink xlink) {
        if (xlink.getUri() != null) {
            return null;
        }
        boolean comment = "Comment".equals(xlink.getContentRole()) || "File Attachment".equals(xlink.getContentRole());
        String fragmentComment = null;
        String fragmentAttached = null;
        for (LocatorForXLink lfx : XLinks.getThreadRoot((XLink)xlink).getLocatorsForXLinkCol()) {
            if (this.uri != null) {
                if (!lfx.getLocator().getURI().equals((Object)this.uri)) continue;
                return lfx.getLocator().getFragment();
            }
            if (lfx.getRole() != null && lfx.getRole().startsWith("xref-source")) {
                return lfx.getLocator().getFragment();
            }
            if (lfx.getRole() != null && lfx.getRole().startsWith("xref-") || !this.matchesConditions(lfx.getLocator().getURI())) continue;
            if (comment) {
                if (lfx.getRole() != null) {
                    fragmentAttached = lfx.getLocator().getFragment();
                    continue;
                }
                fragmentComment = lfx.getLocator().getFragment();
                continue;
            }
            return lfx.getLocator().getFragment();
        }
        if (comment && fragmentComment != null) {
            return fragmentComment;
        }
        return fragmentAttached;
    }

    private void findChanges(HistoryEvent event) {
        XLink xlink = event.getXlink();
        HistoryEvent.EventType type = event.getType();
        if (!type.canHaveChanges()) {
            return;
        }
        XLink previous = this.findPreviousEvent(event);
        if (type == HistoryEvent.EventType.MODIFICATION || type == HistoryEvent.EventType.MOVE || !event.canBeMerged() && (type == HistoryEvent.EventType.UPLOAD || type == HistoryEvent.EventType.CREATION || type == HistoryEvent.EventType.REVERT)) {
            String nowHosturl;
            String beforeHosturl;
            String nowPath;
            String beforePath;
            String beforeTitle;
            String afterLabels;
            String beforeLabels;
            String nowDocid;
            String beforeDoid;
            String nowDesc;
            String beforeDesc;
            String nowArchived;
            Map beforeProps = previous == null ? null : ObjectProperties.toMap((String)previous.getProperties());
            Map nowProps = ObjectProperties.toMap((String)xlink.getProperties());
            String beforeArchived = this.getURIProperty(beforeProps, "archived");
            if (this.hasChanged(beforeArchived, nowArchived = this.getURIProperty(nowProps, "archived"))) {
                event.addChange(HistoryEvent.ChangeType.ARCHIVED, beforeArchived, nowArchived);
            }
            if (this.hasChanged(beforeDesc = this.getURIProperty(beforeProps, "description"), nowDesc = this.getURIProperty(nowProps, "description"))) {
                event.addChange(HistoryEvent.ChangeType.DESCRIPTION, beforeDesc, nowDesc);
            }
            if (this.hasChanged(beforeDoid = this.getURIProperty(beforeProps, "docid"), nowDocid = this.getURIProperty(nowProps, "docid"))) {
                event.addChange(HistoryEvent.ChangeType.DOCID, beforeDoid, nowDocid);
            }
            if (this.hasChanged(beforeLabels = this.getURIProperty(beforeProps, "label"), afterLabels = this.getURIProperty(nowProps, "label"))) {
                event.addChange(HistoryEvent.ChangeType.LABELS, beforeLabels, afterLabels);
            }
            String string = beforeTitle = previous == null ? null : previous.getContentTitle();
            if (this.hasChanged(beforeTitle, xlink.getContentTitle())) {
                event.addChange(HistoryEvent.ChangeType.TITLE, beforeTitle, xlink.getContentTitle());
            }
            if (this.hasChanged(beforePath = this.getURIProperty(beforeProps, "path"), nowPath = this.getURIProperty(nowProps, "path")) && (previous == null || beforePath != null)) {
                event.addChange(HistoryEvent.ChangeType.PATH, beforePath, nowPath);
            }
            if (this.hasChanged(beforeHosturl = this.getURIProperty(beforeProps, "hosturl"), nowHosturl = this.getURIProperty(nowProps, "hosturl"))) {
                event.addChange(HistoryEvent.ChangeType.HOSTURL, beforeHosturl, nowHosturl);
            }
        } else if (type == HistoryEvent.EventType.WORKFLOW || type == HistoryEvent.EventType.TASK) {
            if (previous == null) {
                if (xlink.getStatus() != null) {
                    event.addChange(HistoryEvent.ChangeType.STATUS, null, xlink.getStatus());
                }
                if (xlink.getPriority() != null) {
                    event.addChange(HistoryEvent.ChangeType.PRIORITY, null, xlink.getPriority());
                }
                if (xlink.getDueDate() != null) {
                    event.addChange(HistoryEvent.ChangeType.DUE, null, ISO8601.DATETIME.format(xlink.getDueDate().getTime()));
                }
                if (xlink.getAssignedTo() != null) {
                    event.addChange(HistoryEvent.ChangeType.ASSIGNEDTO, null, xlink.getAssignedTo());
                }
            } else {
                if (this.hasChanged(previous.getStatus(), xlink.getStatus())) {
                    event.addChange(HistoryEvent.ChangeType.STATUS, previous.getStatus(), xlink.getStatus());
                }
                if (this.hasChanged(previous.getPriority(), xlink.getPriority())) {
                    event.addChange(HistoryEvent.ChangeType.PRIORITY, previous.getPriority(), xlink.getPriority());
                }
                if (this.hasChanged(previous.getDueDate(), xlink.getDueDate())) {
                    event.addChange(HistoryEvent.ChangeType.DUE, previous.getDueDate() != null ? ISO8601.DATETIME.format(previous.getDueDate().getTime()) : null, xlink.getDueDate() != null ? ISO8601.DATETIME.format(xlink.getDueDate().getTime()) : null);
                }
                if (this.hasChanged(previous.getAssignedTo(), xlink.getAssignedTo())) {
                    event.addChange(HistoryEvent.ChangeType.ASSIGNEDTO, previous.getAssignedTo(), xlink.getAssignedTo());
                }
            }
        } else if (type == HistoryEvent.EventType.VERSION) {
            if (previous == null) {
                if (xlink.getContentTitle() != null) {
                    event.addChange(HistoryEvent.ChangeType.VERSION, null, xlink.getContentTitle());
                }
            } else if (this.hasChanged(previous.getContentTitle(), xlink.getContentTitle())) {
                event.addChange(HistoryEvent.ChangeType.VERSION, previous.getContentTitle(), xlink.getContentTitle());
            }
        }
    }

    private @Nullable XLink findPreviousEvent(HistoryEvent event) {
        Discussion discussion;
        URI u;
        URI uRI = u = this.uri == null ? this.findURI(event) : this.uri;
        if (u != null) {
            if (event.getType() == HistoryEvent.EventType.MODIFICATION || event.getType() == HistoryEvent.EventType.MOVE || event.getType() == HistoryEvent.EventType.REVERT || event.getType() == HistoryEvent.EventType.UPLOAD) {
                this.preloadModifications(u);
                int index = this.modifications.get(u).indexOf(event.getXlink());
                return index > 0 ? this.modifications.get(u).get(index - 1) : null;
            }
            if (event.getType() == HistoryEvent.EventType.WORKFLOW) {
                this.preloadWorkflows(u);
                int index = this.workflows.get(u).indexOf(event.getXlink());
                return index > 0 ? this.workflows.get(u).get(index - 1) : null;
            }
            if (event.getType() == HistoryEvent.EventType.VERSION) {
                this.preloadVersions(u);
                int index = this.versions.get(u).indexOf(event.getXlink());
                return index > 0 ? this.versions.get(u).get(index - 1) : null;
            }
        }
        if (event.getType() == HistoryEvent.EventType.TASK && (discussion = this.preloadDiscussion(event.getXlink())) != null) {
            if (event.getXlink().getId().equals(discussion.getThreadID())) {
                return null;
            }
            List replies = discussion.getReplies();
            int index = replies == null ? -1 : replies.indexOf(event.getXlink());
            return index > 0 ? (XLink)discussion.getReplies().get(index - 1) : discussion.getRootComment();
        }
        return null;
    }

    private @Nullable HistoryEvent.EventType findType(XLink xl) {
        String contentrole = xl.getContentRole();
        if (contentrole == null) {
            return null;
        }
        if ("File Upload".equals(contentrole)) {
            return HistoryEvent.EventType.UPLOAD;
        }
        if ("File Creation".equals(contentrole)) {
            return HistoryEvent.EventType.CREATION;
        }
        if ("uri-properties".equals(contentrole) && "upload".equals(xl.getType())) {
            return HistoryEvent.EventType.UPLOAD;
        }
        if ("uri-properties".equals(contentrole) && "revert".equals(xl.getType())) {
            return HistoryEvent.EventType.REVERT;
        }
        if ("uri-properties".equals(contentrole) && "creation".equals(xl.getType())) {
            return HistoryEvent.EventType.CREATION;
        }
        if ("uri-properties".equals(contentrole) && "move".equals(xl.getType())) {
            return HistoryEvent.EventType.MOVE;
        }
        if ("uri-properties".equals(contentrole)) {
            return HistoryEvent.EventType.MODIFICATION;
        }
        if ("Documentation-Note".equals(contentrole)) {
            return HistoryEvent.EventType.NOTE;
        }
        if ("Documentation-Structure".equals(contentrole)) {
            return HistoryEvent.EventType.STRUCTURE;
        }
        if (XLinks.isWorkflow((XLink)xl)) {
            return HistoryEvent.EventType.WORKFLOW;
        }
        if ("Documentation-Version".equals(contentrole)) {
            return HistoryEvent.EventType.VERSION;
        }
        if ("Documentation-Release".equals(contentrole)) {
            if (xl.getStatus() != null) {
                return HistoryEvent.EventType.WORKFLOW;
            }
            return HistoryEvent.EventType.VERSION;
        }
        if ("Documentation-Original".equals(contentrole)) {
            return null;
        }
        if (contentrole.startsWith("Documentation")) {
            if ("Documentation-Draft".equals(xl.getStatus())) {
                return HistoryEvent.EventType.DRAFT;
            }
            return HistoryEvent.EventType.EDIT;
        }
        if (contentrole.startsWith("XRef")) {
            if (new XRef(xl).isImage()) {
                return HistoryEvent.EventType.IMAGE;
            }
            return HistoryEvent.EventType.XREF;
        }
        if ("Comment".equals(contentrole) || "File Attachment".equals(contentrole)) {
            if (xl.getStatus() != null) {
                return HistoryEvent.EventType.TASK;
            }
            return HistoryEvent.EventType.COMMENT;
        }
        return null;
    }

    private boolean matchesConditions(URI uri) {
        String path = uri.getPath();
        return !(path.contains("/servlet/com.pageseeder.general/") || this.folder != null && !path.startsWith(this.folder) || this.documenttype != null && !("psml-" + this.documenttype + "-").equals(uri.getBehavior()));
    }

    private @Nullable String getURIProperty(@Nullable Map<String, List<String>> props, String property) {
        return props == null || !props.containsKey(property) || props.get(property).isEmpty() ? null : String.join((CharSequence)",", (Iterable<? extends CharSequence>)props.get(property));
    }

    private boolean hasChanged(@Nullable Object before, @Nullable Object after) {
        return after != null && before == null || after == null && before != null || after != null && !before.equals(after);
    }

    private Discussion preloadDiscussion(XLink task) {
        XLink root = XLinks.getThreadRoot((XLink)task);
        Discussion d = this.discussions.get(root.getId());
        if (d == null) {
            d = new Discussion(root, Collections.singleton(this.group.getName()));
            d.loadAllComments(this.database, -1);
            this.discussions.put(root.getId(), d);
        }
        return d;
    }

    private void preloadModifications(@Nullable URI u) {
        if (u != null && !this.modifications.containsKey(u)) {
            try {
                this.modifications.put(u, DatabaseQuery.getXLinksByURIModification((Database)this.database, (Long)u.getId(), (boolean)false));
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load modifications for {}", (Object)u.getId(), (Object)ex);
            }
        }
    }

    private void preloadVersions(@Nullable URI u) {
        if (u != null && !this.versions.containsKey(u)) {
            try {
                List vs = URIRule.getReleasesForURI((Database)this.database, (URI)u);
                vs.sort(CHRONOLOGICAL_XLINKS);
                this.versions.put(u, vs);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load versions for {}", (Object)u.getId(), (Object)ex);
            }
        }
    }

    private void preloadWorkflows(@Nullable URI u) {
        if (u != null && !this.workflows.containsKey(u)) {
            try {
                List vs = URIRule.getWorkflowsForURI((Database)this.database, (URI)u, null);
                vs.sort(CHRONOLOGICAL_XLINKS);
                this.workflows.put(u, vs);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load workflows for {}", (Object)u.getId(), (Object)ex);
            }
        }
    }
}

