/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetURIsForURL
implements Generator,
SingleCheck {
    private static final int MAX_NB_RESULTS = 200;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        String urlString = req.getParameter((Parameter)StandardParameters.url);
        if (req.getURI() != null) {
            urlString = URIRule.getURIString((URI)req.getURI());
        }
        if (urlString == null) {
            return new NoCheck();
        }
        try {
            URL url = RuleUtils.urlEncodeNormalize((String)urlString);
            String path = url.getPath();
            if (path == null || path.isEmpty()) {
                return new NoCheck();
            }
        }
        catch (MalformedURLException ex) {
            return new NoCheck();
        }
        return new ViewURICheck(req.getGroup(), urlString);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URL url;
        String type = req.getParameter((Parameter)StandardParameters.type, "all");
        String relationship = req.getParameter((Parameter)StandardParameters.relationship);
        String exclude = req.getParameter((Parameter)StandardParameters.exclude);
        int page = Long.valueOf(req.getParameter((Parameter)StandardParameters.page, 1L)).intValue();
        int pagesize = Long.valueOf(req.getParameter((Parameter)StandardParameters.pagesize, 200L)).intValue();
        String urlString = req.getParameter((Parameter)StandardParameters.url);
        if (req.getURI() != null) {
            urlString = URIRule.getURIString((URI)req.getURI());
        }
        if (urlString == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL, "URL not specified");
            return;
        }
        try {
            url = RuleUtils.urlEncodeNormalize((String)urlString);
        }
        catch (MalformedURLException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL, "Invalid URL " + urlString + ": " + ex.getMessage());
            return;
        }
        boolean siblings = "siblings".equals(relationship);
        boolean includeFiles = !"folder".equals(type);
        boolean includeFolders = !"document".equals(type);
        String path = url.getPath();
        path = path.replaceFirst("/$", "");
        if (path.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL, "Invalid URL " + urlString + ": No Path");
            return;
        }
        if (siblings) {
            path = path.replaceFirst("/[^/]+$", "");
        }
        String url_host = HostRule.resolveAlias((Database)req.getDatabase(), (String)url.getHost());
        List uris = DatabaseQuery.getURIsBySchemeHostPortDirectoryType((Database)req.getDatabase(), (Long)req.getGroup().getId(), (String)url.getProtocol(), (String)url_host, (Integer)url.getPort(), (String)path, (boolean)includeFiles, (boolean)includeFolders, (String)relationship, (String)exclude, (int)page, (int)pagesize, (boolean)true);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("uris");
        if (uris.size() > pagesize) {
            out.field("limitreached", true);
        }
        out.startCollection("uris", OutputPrinter.CollectionOption.JSON_ONLY);
        for (int i = 0; i < uris.size() && i < pagesize; ++i) {
            if (((URI)uris.get(i)).getPath().endsWith("/")) continue;
            out.writeURI((URI)uris.get(i), true, req.getDatabase());
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

