/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.Date;

@Requires(database=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetURI
implements Generator,
SingleCheck,
Cacheable {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(req.getURI()));
        }
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    public String getETag(GeneratorRequest req) {
        Date modified = req.getURI().getLastModified();
        boolean sharing = req.getParameter((Parameter)StandardParameters.sharing, false);
        return modified != null && !sharing ? MD5.hash((String)Long.toString(modified.getTime())) : null;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        boolean sharing = req.getParameter((Parameter)StandardParameters.sharing, false);
        UniversalPrinter out = res.getUniversalWriter();
        URI uri = req.getURI();
        out.writeExternalURI(uri, false, req.getDatabase());
        if (req.getMember() != null && sharing) {
            this.addSharing(req.getDatabase(), uri, req.getMember(), out);
        }
        out.endObject();
        out.flush();
    }

    private void addSharing(Database db, URI uri, Member member, UniversalPrinter out) {
        UserDetailsManager manager = new UserDetailsManager();
        UserDetails userdetails = manager.get(db, member.getId());
        if (!uri.getExternal().booleanValue()) {
            out.writeURISharingDetails(uri.getId(), userdetails, db);
        }
    }
}

