/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

@Requires(member=true, parameters={"url"})
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class GetExternalURIWithURL
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewMemberCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("all".equals(req.getParameter((Parameter)StandardParameters.returngroups))) {
            return new CreateProjectCheck();
        }
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        URL url;
        String urlString = req.getParameter((Parameter)StandardParameters.url);
        try {
            url = RuleUtils.urlEncodeNormalize((String)urlString);
        }
        catch (MalformedURLException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL, "Invalid URL " + urlString + ": " + ex.getMessage());
            return;
        }
        URI uri = URIRule.getURIByURL((Database)req.getDatabase(), (URL)url);
        if (uri == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.URI_NOT_FOUND);
            return;
        }
        if (!uri.getExternal().booleanValue()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "URI is not external");
            return;
        }
        Long memberid = req.getMember().getId();
        Database db = req.getDatabase();
        String allgroups = req.getParameter((Parameter)StandardParameters.returngroups, "none");
        UniversalPrinter out = res.getUniversalWriter();
        out.writeExternalURI(uri, false, null);
        if (!"none".equals(allgroups)) {
            out.writeURLUsage(uri, memberid, "all".equals(allgroups), db);
        }
        out.endObject();
        out.flush();
    }
}

