/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DeleteURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.state.GroupStateManager;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(uri=true)
@PublicAPI
public final class DeleteExternalURI
implements Generator,
SingleCheck {
    @ContentPermission(value=DeleteURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!URIs.isExternal((URI)req.getURI())) {
            return new ForbiddenCheck();
        }
        return new DeleteURICheck(req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        URI uri = req.getURI();
        Database db = req.getDatabase();
        assert (uri != null);
        URIRule.URIToIndex uti = new URIRule.URIToIndex(uri, db);
        URIRule.updateLastModifedForXRefs((URI)uri, (Date)new Date(), (Database)db);
        URIRule.deleteURI((Database)db, (URI)uri, (URIRule.URIToIndex)uti);
        req.getTransaction().commitAndStart();
        ChangesManager changes = ChangesManager.getInstance();
        ChangesBatch batch = new ChangesBatch("Deleting URL");
        changes.startBatch(db, batch);
        changes.deleteURL(db, batch, uti.uid, uti.docid, uti.path, Collections.emptyList());
        if (uti.workflowid != null) {
            changes.deleteWorkflow(db, batch, uti.workflowid, uti.groups);
        }
        for (Object id : uti.commentids) {
            changes.deleteComment(db, batch, (Long)id, uti.groups);
        }
        changes.completeBatch(db, batch);
        Date current = new Date();
        for (Group grp : uti.groups) {
            GroupStateManager.singleton().setCommentsModified(grp, current);
        }
        XMLWriter xml = res.getXMLWriter();
        xml.emptyElement("uri-delete");
    }
}

