/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Rules;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

@Requires(database=true, group=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateFolder
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        URL dest;
        Group group = req.getGroup();
        assert (group != null);
        URI uri = req.getURI();
        String url = req.getParameter((Parameter)StandardParameters.url);
        String dadurl = req.getParameter((Parameter)StandardParameters.parenturl);
        String dadname = req.getParameter((Parameter)StandardParameters.parentfolder);
        if (url != null) {
            int lastSlash = url.lastIndexOf(47);
            if (lastSlash == -1) {
                return new NoCheck();
            }
            dadurl = url.substring(0, lastSlash);
        }
        try {
            dest = this.computeDestination(uri, dadurl, dadname, group);
        }
        catch (URIException e) {
            return new NoCheck();
        }
        if (dest != null) {
            return new EditURICheck(req.getGroup(), dest.toString());
        }
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI turi;
        int port;
        URL destination;
        Database db = req.getDatabase();
        Group group = req.getGroup();
        URI uri = req.getURI();
        Member member = req.getMember();
        assert (group != null && member != null);
        String name = req.getParameter((Parameter)StandardParameters.name);
        String title = req.getParameter((Parameter)StandardParameters.title);
        String documentid = req.getParameter((Parameter)StandardParameters.docid);
        String description = req.getParameter((Parameter)StandardParameters.description);
        String labels = req.getParameter((Parameter)StandardParameters.labels);
        String url = req.getParameter((Parameter)StandardParameters.url);
        String dadurl = req.getParameter((Parameter)StandardParameters.parenturl);
        String dadname = req.getParameter((Parameter)StandardParameters.parentfolder);
        if (!URIUtils.checkLabels(res, labels)) {
            return;
        }
        if (!this.checkParameters(url, dadurl, name, dadname, res)) {
            return;
        }
        if (url != null) {
            int lastSlash = url.lastIndexOf(47);
            if (lastSlash == -1) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DESTINATION, "Invalid URL destination " + url);
                return;
            }
            dadurl = url.substring(0, lastSlash);
            name = URLCoder.decode((String)url.substring(lastSlash + 1));
        }
        try {
            destination = this.computeDestination(uri, dadurl, dadname, group);
        }
        catch (URIException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DESTINATION, ex.getMessage());
            return;
        }
        if (!Strings.isEmpty((String)documentid)) {
            if (!URIRule.isValidDocumentID((String)documentid)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DOCUMENT_ID);
                return;
            }
            URI turi2 = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)destination.getHost(), (String)documentid);
            if (turi2 != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.DOCUMENT_ID_EXISTING, "The document id " + documentid + " is already being used (" + turi2.getDecodedPath() + ").");
                return;
            }
        }
        String escapedParentPath = RuleUtils.replaceNonFolderCharsKeepSlashes((String)URLCoder.decode((String)destination.getPath()));
        String encodedParentPath = RuleUtils.urlEncodeFilepath((String)escapedParentPath);
        String newName = RuleUtils.replaceNonFolderChars((String)name);
        String path = encodedParentPath + "/" + URLCoder.encode((String)newName);
        String realpath = URIRule.getRealPath((String)Settings.getContextPath(), (String)path);
        if (!newName.equals(name) && title == null) {
            title = name;
        }
        if ((port = destination.getPort()) == -1) {
            port = Rules.getDefaultPort((String)destination.getProtocol());
        }
        if ((turi = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)path)) != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EXISTING_URL, "The URI already exists.");
            return;
        }
        File f = new File(realpath);
        if (f.exists()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EXISTING_URL, "The file already exists on the file system.");
            return;
        }
        f.mkdirs();
        if (!f.exists()) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Unable to create folder " + path + " on file system");
            return;
        }
        List created = URIRule.ensureFolderURIsExist((Database)db, (Member)member, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)path);
        try {
            String[] labs = Strings.isEmpty((String)labels) ? null : labels.split(",");
            turi = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabels((Database)db, null, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)path, null, (String)description, (String)title, (String)"folder", (String[])labs, (boolean)true);
            created.add(turi);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create URI in DB for" + path);
            f.delete();
            return;
        }
        if (turi == null) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create URI in DB for" + path);
            f.delete();
            return;
        }
        if (!Strings.isEmpty((String)documentid)) {
            turi.setDocID(documentid);
        }
        URIRule.addURIHistoryXLink((URI)turi, (Member)member, (Date)turi.getDateCreated(), (String)"creation", null, (Database)db);
        req.getTransaction().commitAndStart();
        for (URI u : created) {
            ChangesManager.getInstance().createURI(db, u, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)u.getId()));
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("folder-creation");
        if (!newName.equals(name)) {
            out.field("renamed", true);
            out.field("original-name", name);
        }
        out.writeURI(turi);
        out.endObject();
        out.flush();
    }

    private boolean checkParameters(@Nullable String url, @Nullable String parentUrl, @Nullable String filename, @Nullable String parentName, GeneratorResponse res) {
        if (filename != null && url != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "Cannot specify both url and name parameters");
            return false;
        }
        if (filename == null && url == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "One of url or name parameters must be specified");
            return false;
        }
        if (parentUrl != null && url != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "Cannot specify both url and parenturl parameters");
            return false;
        }
        if (parentUrl != null && parentName != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "Cannot specify both parentfolder and parenturl parameters");
            return false;
        }
        if (url != null && parentName != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "Cannot specify both parentfolder and url parameters");
            return false;
        }
        return true;
    }

    private URL computeDestination(@Nullable URI uri, @Nullable String parentUrl, @Nullable String parentName, Group group) throws URIException, DatabaseException {
        String parenturl = parentUrl;
        if (uri != null) {
            if (!"folder".equals(uri.getType())) {
                throw new URIException("Invalid parent URI specified (not a folder)");
            }
            parenturl = URIRule.getURIString((URI)uri);
        }
        if (parenturl == null) {
            GroupURI guri = group.hasFlag('f') ? GroupRule.getFolderGroupURI((Group)group) : GroupURIRule.getDefaultGroupURI((Group)group);
            if (parentName != null) {
                if (((String)parentName).charAt(0) != '/') {
                    parentName = "/" + (String)parentName;
                }
            } else {
                parentName = "";
            }
            parenturl = URIRule.getURIString((String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)(GlobalSettings.getSitePrefix() + "/" + group.getName().replace('-', '/') + (String)parentName));
        }
        parenturl = parenturl.replaceAll("/$", "");
        try {
            return RuleUtils.urlEncodeNormalize((String)parenturl);
        }
        catch (MalformedURLException ex) {
            throw new URIException("Invalid URL " + parenturl + ": " + ex.getMessage());
        }
    }
}

