/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddURLsCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import com.pageseeder.url.URLCreator;
import com.pageseeder.url.URLException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, member=true, parameters={"url"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateExternalURI
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateExternalURI.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        String url = req.getParameter((Parameter)StandardParameters.url);
        assert (url != null);
        try {
            if (!URIRule.isExternal((URL)RuleUtils.urlEncodeNormalize((String)url), (Database)req.getDatabase())) {
                return new ForbiddenCheck();
            }
        }
        catch (MalformedURLException ex) {
            return new NoCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddURLsCheck());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI uri;
        Member member = req.getMember();
        String urlString = req.getParameter((Parameter)StandardParameters.url);
        String title = req.getNonEmptyParameter((Parameter)StandardParameters.title);
        String type = req.getNonEmptyParameter((Parameter)StandardParameters.type);
        String description = req.getNonEmptyParameter((Parameter)StandardParameters.description);
        String sizeString = req.getNonEmptyParameter((Parameter)StandardParameters.size);
        String mediatype = req.getNonEmptyParameter((Parameter)StandardParameters.mediatype);
        String labels = req.getNonEmptyParameter((Parameter)StandardParameters.labels);
        if (!URIUtils.checkLabels(res, labels)) {
            return;
        }
        assert (urlString != null && member != null);
        long size = -1L;
        if (sizeString != null) {
            try {
                size = Long.parseLong(sizeString);
            }
            catch (NumberFormatException ex) {
                size = -1L;
            }
            if (size < 0L) {
                LOGGER.error("Invalid size for URL: {}", (Object)sizeString);
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_SIZE);
                return;
            }
        }
        if (type != null && !URIRule.isValidDocumentType((String)type)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The URL type is not valid");
            return;
        }
        Database db = req.getDatabase();
        Member author = req.getMember();
        Permissions perm = new Permissions();
        UserDetails userdetails = new UserDetailsManager().get(db, member.getId(), false);
        boolean uriOwner = PermissionManager.check((Long)author.getId(), (UserDetails)userdetails, (Database)db, (Permissions)perm, (PermissionCheck)new EditAllURLsCheck());
        URLCreator creator = new URLCreator(author, uriOwner);
        creator.setDetails(title, description, type, mediatype, size, labels == null ? null : labels.split(","));
        try {
            uri = creator.create(urlString, db, false);
        }
        catch (URLException ex) {
            if (ex.getError() == null) {
                res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
            } else {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)ex.getError(), ex.getMessage());
            }
            return;
        }
        req.getTransaction().commitAndStart();
        ChangesManager.getInstance().createURI(db, uri, Collections.emptyList());
        res.setStatus(GeneratorStatus.CREATED);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("uri-creation");
        if (creator.wasExistingURI()) {
            out.field("existing", true);
        }
        if (creator.wasUnarchived()) {
            out.field("unarchived", true);
        }
        out.writeExternalURI(uri);
        out.endObject();
        out.flush();
    }
}

