/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.OverallSummaryBuilder;
import com.pageseeder.base.logback.XLogException;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.thread.ProcessLogger;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@PublicAPI
public final class ViewSummaryLogs
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("true".equals(req.getParameter((Parameter)StandardParameters.allgroups))) {
            return new AdminSystemCheck(req.getHttpServletRequest());
        }
        return new EditURICheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        XMLWriter xml = res.getXMLWriter();
        ProcessLogger logger = ProcessManager.getInstance().getLogger();
        OverallSummaryBuilder summary = new OverallSummaryBuilder((XLoggerAdaptor)logger);
        try {
            if ("true".equals(req.getParameter((Parameter)StandardParameters.allgroups))) {
                summary.build();
                summary.toXML(xml);
            } else if (req.getGroup() != null) {
                summary.setGroup(req.getGroup().getId());
                summary.build();
                summary.toXML(xml);
            } else {
                res.setError(GeneratorStatus.BAD_REQUEST, "No group specified");
            }
        }
        catch (XLogException ex) {
            req.getLogger((Object)this).error("Unable to generate log summary", (Throwable)ex);
        }
        xml.flush();
    }
}

