/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.document.URIException;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.psml.PSMLContentMatcher;
import com.pageseeder.utils.MatchOptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;

public class PSMLContentMatchThread
extends ProcessThread {
    private static final String SITE_PREFIX = GlobalSettings.getSitePrefix();
    private final String term;
    private final Queue<Long> urisToScan = new LinkedList<Long>();
    private boolean logMessages = true;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private int currentProgress = 0;
    private int totalUris = 0;
    private static final int MAX_MATCHES_COUNT = 100;
    private final List<URIScanMatch> matches = new CopyOnWriteArrayList<URIScanMatch>();
    private MatchOptions options = MatchOptions.exactMatch();

    private PSMLContentMatchThread(String membername, Group group, String term) {
        super(membername, "String match thread for group " + group.getName(), group);
        this.term = term;
    }

    public static PSMLContentMatchThread newInstance(String username, Group group, String term) {
        return new PSMLContentMatchThread(username, group, term);
    }

    public void addURI(Long uriid) {
        if (!this.urisToScan.contains(uriid)) {
            this.urisToScan.add(uriid);
        }
    }

    public void setResultAttribute(String name, String value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.options = this.options.caseSensitive(caseSensitive);
    }

    public void setWord(boolean word) {
        this.options = this.options.word(word);
    }

    public void setLiteral(boolean literal) {
        this.options = this.options.literal(literal);
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.totalUris);
        out.field("current", (long)this.currentProgress);
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            out.field(attribute.getKey(), attribute.getValue());
        }
        out.startObject("options");
        out.field("term", this.term);
        out.field("literal", this.options.isLiteral());
        out.field("case-sensitive", this.options.isCaseSensitive());
        out.field("word", this.options.isWord());
        out.endObject();
        if (!this.matches.isEmpty()) {
            out.startCollection("matches");
            for (URIScanMatch m : this.matches) {
                m.print(out);
            }
            out.endCollection();
        }
        out.endObject();
    }

    public void process() {
        this.run(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Database database, Transaction transaction) {
        this.totalUris = this.urisToScan.size();
        if (this.urisToScan.isEmpty()) {
            this.updateStatus(ProcessStage.Status.COMPLETED, "No documents to search!", this.logMessages);
            return;
        }
        Transaction tr = transaction;
        Database db = database;
        boolean newTransaction = false;
        if (db == null && tr == null) {
            try {
                db = Database.open();
                tr = new Transaction(db);
                newTransaction = true;
            }
            catch (OpenDatabaseException e) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to open database", this.logMessages);
                return;
            }
        }
        try {
            if (newTransaction) {
                tr.begin();
            }
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + this.totalUris + " documents to search.");
            PSMLContentMatcher matcher = new PSMLContentMatcher(this.term);
            matcher.setOptions(this.options);
            matcher.loadLockStatuses(db, group);
            while (this.urisToScan.peek() != null) {
                Long uriid = this.urisToScan.remove();
                if (this.wasCancelled()) break;
                ++this.currentProgress;
                URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                if (uri == null || PSMLContentMatchThread.isArchived(uri, group)) continue;
                if (this.wasCancelled()) break;
                this.scanDocuments(db, group, uri, matcher);
                if (this.matches.size() >= 100) break;
                if (!newTransaction) continue;
                tr.commitAndStart();
            }
            if (newTransaction) {
                tr.commit();
            }
            this.updateStatus(ProcessStage.Status.COMPLETED, "Found " + this.matches.size() + " matches", this.logMessages);
        }
        catch (StartTransactionException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to start transaction", this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
        }
        catch (QueryFailedException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to run database query: " + e.getMessage(), this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
        }
        catch (CommitTransactionException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to commit transaction", this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
        }
        catch (Throwable e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to process files: " + e.getMessage(), this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
        }
        finally {
            if (newTransaction) {
                db.close();
                db = null;
            }
        }
    }

    private int scanDocuments(Database db, Group group, URI uri, PSMLContentMatcher matcher) {
        String path = uri.getPath();
        try {
            List<PSMLContentMatcher.PSMLContentMatch> matches = matcher.listMatches(db, group, uri);
            if (!matches.isEmpty()) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + matches.size() + " matches in " + path);
                for (PSMLContentMatcher.PSMLContentMatch m : matches) {
                    this.matches.add(new URIScanMatch(uri.getDisplayTitle(), uri.getPath(), m));
                }
            }
            return matches.size();
        }
        catch (URIException | IOException ex) {
            this.updateStatus(ProcessStage.Status.ERROR, "Failed to process " + path + ": " + ex.getMessage(), this.logMessages);
            return 0;
        }
    }

    private static boolean isArchived(URI uri, Group group) {
        return uri.getPath().startsWith(SITE_PREFIX + "/" + group.getName().replace('-', '/') + "/archive/");
    }

    private static class URIScanMatch {
        final String urititle;
        final String uripath;
        final PSMLContentMatcher.PSMLContentMatch match;

        public URIScanMatch(String title, String path, PSMLContentMatcher.PSMLContentMatch match) {
            this.urititle = title;
            this.uripath = path;
            this.match = match;
        }

        void print(OutputPrinter out) {
            out.startObject("match");
            out.field("uriid", this.match.getUriid());
            out.field("uripath", this.uripath);
            out.field("urititle", this.urititle);
            out.field("fragment", this.match.getFragment());
            out.field("count", (long)this.match.getCount());
            out.field("editable", this.match.isEditable());
            if (this.match.getModified() != null) {
                out.field("modified", this.match.getModified());
            }
            out.field("content", this.match.getContent(), OutputPrinter.FieldOption.XML_COPY);
            if (out.getType() == OutputType.XML) {
                out.startObject("extract");
                out.field("value", this.match.getExtract(), OutputPrinter.FieldOption.XML_COPY);
                out.endObject();
            } else {
                out.field("extract", this.match.getExtract(), OutputPrinter.FieldOption.XML_COPY);
            }
            out.endObject();
        }
    }
}

