/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(parameters={"threadid"})
@PublicAPI
public final class GetThreadProgress
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        String tid = req.getParameter((Parameter)StandardParameters.threadid);
        ProcessThread thread = ProcessManager.getInstance().getThread(tid);
        if (thread == null) {
            return new NoCheck();
        }
        return new ViewMemberCheck(DatabaseQuery.getMemberByUsername((Database)req.getDatabase(), (String)thread.getUsername()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String tid;
        ProcessManager manager = ProcessManager.getInstance();
        ProcessThread t = manager.getThread(tid = req.getParameter((Parameter)StandardParameters.threadid));
        if (t != null) {
            Group group = req.getGroup();
            if (group != null && !group.getId().equals(t.getGroupID())) {
                res.setError(GeneratorStatus.NOT_FOUND, "There are no threads in group " + group.getName() + " with ID " + tid);
                return;
            }
            manager.clearIfFinished(tid);
            XMLWriter xml = res.getXMLWriter();
            t.toXML(xml);
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "There are no threads with ID " + tid);
        }
    }
}

