/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.system;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.util.SHA256;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.JSON, OutputType.XML})
public final class About
implements Generator,
Cacheable,
SingleCheck {
    private static final Pattern LIBRARY_PATTERN = Pattern.compile("^(.{0,100})-(.{0,50})\\.(.{0,10})$");
    private @Nullable AboutData cache = null;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    public String getETag(GeneratorRequest req) {
        AboutData data = this.getAboutData(req);
        if (!data.equals(this.cache)) {
            this.cache = data;
        }
        return data.etag();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        AboutData data = this.cache;
        if (data == null) {
            data = this.getAboutData(req);
        }
        UniversalPrinter out = res.getUniversalWriter();
        data.toOutput(out);
        out.flush();
    }

    private AboutData getAboutData(GeneratorRequest req) {
        String dbVersion = About.getTableVersion(req.getDatabase());
        String serverVersion = req.getHttpServletRequest().getServletContext().getServerInfo();
        List<String> libraries = About.listLibraries();
        OSReleaseInfo osInfo = About.getOsReleaseInfo(System.getProperties());
        return new AboutData(dbVersion, libraries, serverVersion, osInfo);
    }

    private static String getTableVersion(Database db) {
        String version;
        try {
            version = DatabaseQuery.getTablesVersion((Database)db);
        }
        catch (QueryFailedException ex) {
            version = "pre 4.04";
        }
        return version;
    }

    private static List<String> listLibraries() {
        File lib = new File(Settings.getContextPath(), "WEB-INF" + File.separator + "lib");
        String[] libs = lib.list((dir, name) -> name.matches(LIBRARY_PATTERN.pattern()));
        return libs != null ? Arrays.asList(libs) : Collections.emptyList();
    }

    private static OSReleaseInfo getOsReleaseInfo(Properties system) {
        Path osRelease;
        String name = system.getProperty("os.name");
        String version = system.getProperty("os.version");
        if ("Linux".equals(name) && Files.isReadable(osRelease = Paths.get("/etc/os-release", new String[0]))) {
            try {
                List<String> lines = Files.readAllLines(osRelease);
                for (String line : lines) {
                    if (line.startsWith("NAME=")) {
                        name = line.substring(5).replace("\"", "").trim();
                        continue;
                    }
                    if (!line.startsWith("VERSION=")) continue;
                    version = line.substring(8).replace("\"", "").trim();
                }
            }
            catch (IOException ex) {
                LoggerFactory.getLogger(About.class).error("Unable to read /etc/os-release", (Throwable)ex);
            }
        }
        return new OSReleaseInfo(name, version);
    }

    private static class OSReleaseInfo {
        final String name;
        final String version;

        public OSReleaseInfo(String name, String version) {
            this.name = Objects.requireNonNull(name);
            this.version = Objects.requireNonNull(version);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OSReleaseInfo that = (OSReleaseInfo)o;
            return this.name.equals(that.name) && this.version.equals(that.version);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.version.hashCode();
        }
    }

    private static class AboutData {
        private final String dbVersion;
        private final String serverVersion;
        private final List<String> libraries;
        private final OSReleaseInfo osInfo;
        private final String etag;

        AboutData(String dbVersion, List<String> libraries, String serverVersion, OSReleaseInfo osInfo) {
            this.dbVersion = dbVersion;
            this.libraries = libraries;
            this.serverVersion = serverVersion;
            this.osInfo = osInfo;
            this.etag = SHA256.hash((String)(serverVersion + dbVersion + libraries.toString() + String.valueOf(osInfo)));
        }

        void toOutput(UniversalPrinter out) {
            out.startObject("about");
            out.startObject("database");
            out.field("tables-version", this.dbVersion);
            out.endObject();
            Properties system = System.getProperties();
            out.startObject("jvm");
            out.field("name", system.getProperty("java.vm.name", ""));
            out.field("vendor", system.getProperty("java.vm.vendor", ""));
            out.field("info", system.getProperty("java.vm.info", ""));
            out.field("version", system.getProperty("java.vm.version", ""));
            out.endObject();
            out.startObject("os");
            out.field("name", this.osInfo.name);
            out.field("version", this.osInfo.version);
            out.field("arch", system.getProperty("os.arch", ""));
            out.endObject();
            out.startObject("server");
            out.field("info", this.serverVersion);
            out.endObject();
            out.startCollection("libraries");
            for (String library : this.libraries) {
                Matcher matcher = LIBRARY_PATTERN.matcher(library);
                out.startObject("library");
                boolean found = matcher.find();
                out.field("version", found ? matcher.group(2) : "");
                out.field("extension", found ? matcher.group(3) : "");
                out.field("name", found ? matcher.group(1) : library, OutputPrinter.FieldOption.XML_TEXT);
                out.endObject();
            }
            out.endCollection();
            out.endObject();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o instanceof AboutData && ((AboutData)o).etag.equals(this.etag);
        }

        public int hashCode() {
            return this.etag.hashCode();
        }

        public String etag() {
            return this.etag;
        }
    }
}

