/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.service.Service;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.furi.URIPattern;
import org.pageseeder.furi.URIResolver;

public final class ServiceRegistry {
    private final Map<Service.HttpMethod, ServiceMap> registry = new EnumMap<Service.HttpMethod, ServiceMap>(Service.HttpMethod.class);

    public ServiceRegistry() {
        for (Service.HttpMethod m : Service.HttpMethod.values()) {
            this.registry.put(m, new ServiceMap());
        }
    }

    public void register(Service service) throws IllegalArgumentException {
        Objects.requireNonNull(service, "No service to register.");
        this.registry.get((Object)service.method()).put(service.pattern(), service);
    }

    public @Nullable Service find(String url, Service.HttpMethod method) {
        return this.registry.get((Object)method).get(url);
    }

    public void clear() {
        for (ServiceMap services : this.registry.values()) {
            services.clear();
        }
    }

    private static class ServiceMap {
        private final Map<String, Service> mapping = new ConcurrentHashMap<String, Service>();
        private final List<URIPattern> patterns = new ArrayList<URIPattern>();

        private ServiceMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(URIPattern pattern, Service service) {
            this.mapping.put(pattern.toString(), service);
            List<URIPattern> list = this.patterns;
            synchronized (list) {
                this.patterns.add(pattern);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable Service get(String url) {
            Service service = this.mapping.get(url);
            if (service == null) {
                URIPattern p;
                URIResolver resolver = new URIResolver(url);
                List<URIPattern> list = this.patterns;
                synchronized (list) {
                    p = resolver.find(this.patterns);
                }
                if (p != null) {
                    service = this.mapping.get(p.toString());
                }
            }
            return service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.mapping.clear();
            List<URIPattern> list = this.patterns;
            synchronized (list) {
                this.patterns.clear();
            }
        }
    }
}

