/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.GeneratorFactory;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.service.Service;
import com.pageseeder.service.ServiceException;
import com.pageseeder.service.ServiceRegistry;
import com.pageseeder.service.ServicesHandler10;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceManager.class);
    private static @Nullable SAXParserFactory parsers;
    private final ServiceRegistry registry = new ServiceRegistry();
    private final File config;
    private final GeneratorFactory factory;
    private boolean loaded = false;
    private boolean loading = false;

    ServiceManager(File config, GeneratorFactory factory) {
        this.config = config;
        this.factory = factory;
    }

    public @Nullable Service getInstance(@Nullable String uri, Service.HttpMethod method) {
        if (uri == null) {
            return null;
        }
        if (!this.loaded) {
            try {
                this.load();
                this.loaded = true;
            }
            catch (ServiceException ex) {
                LOGGER.error("Error reported while loading services", (Throwable)ex);
            }
        }
        return this.registry.find(uri, method);
    }

    public void load() throws ServiceException {
        this.load(this.config);
    }

    private synchronized void load(@Nullable File xml) throws ServiceException {
        if (this.loading) {
            return;
        }
        this.loading = true;
        if (xml == null || !xml.exists()) {
            throw new IllegalArgumentException("The generators configuration could not be found in " + String.valueOf(xml));
        }
        SAXParser parser = ServiceManager.getParser();
        try {
            XMLReader reader = parser.getXMLReader();
            HandlingDispatcher dispatcher = new HandlingDispatcher(reader, this.registry, this.factory);
            reader.setContentHandler(dispatcher);
            String path = xml.toURI().toString();
            LOGGER.info("Parsing {}", (Object)path.substring(path.indexOf("WEB-INF") + 7));
            reader.parse(new InputSource(xml.toURI().toString()));
        }
        catch (SAXParseException ex) {
            LOGGER.error("SAX Parsing error line {}: {}", (Object)ex.getLineNumber(), (Object)ex.getMessage());
            throw new ServiceException("Could not parse services: " + ex.getMessage() + " line" + ex.getLineNumber());
        }
        catch (SAXException ex) {
            LOGGER.error("An SAX error occurred while reading XML configuration of generators", (Throwable)ex);
            throw new ServiceException("Could not parse file. " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LOGGER.error("An I/O error occurred while reading XML configuration of generators", (Throwable)ex);
            throw new ServiceException("Could not read file.", ex);
        }
        finally {
            this.loading = false;
        }
    }

    public synchronized void clear() {
        this.registry.clear();
        this.loaded = false;
    }

    public static SAXParser getParser() throws ServiceException {
        SAXParserFactory factory = parsers;
        SAXParser parser = null;
        try {
            if (factory == null) {
                factory = XMLHelpers.safeSAXParserFactory();
                factory.setValidating(true);
                factory.setNamespaceAware(true);
                factory.setFeature("http://xml.org/sax/features/validation", true);
                factory.setFeature("http://xml.org/sax/features/namespaces", true);
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                parsers = factory;
            }
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new ServiceException("Could not configure SAX parser.", ex);
        }
        catch (SAXException ex) {
            throw new ServiceException("Could not setup SAX parser factory: " + ex.getMessage(), ex);
        }
        return parser;
    }

    private static final class HandlingDispatcher
    extends DefaultHandler
    implements ContentHandler {
        private final ServiceRegistry registry;
        private final GeneratorFactory factory;
        private final XMLReader reader;

        public HandlingDispatcher(XMLReader reader, ServiceRegistry registry, GeneratorFactory factory) {
            this.reader = reader;
            this.registry = registry;
            this.factory = factory;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            ContentHandler handler = this.getHandler(localName, atts);
            if (handler != null) {
                try {
                    handler.startElement(uri, localName, qName, atts);
                    this.reader.setContentHandler(handler);
                }
                catch (SAXException ex) {
                    LOGGER.warn("Generated by wrapped handler", (Throwable)ex);
                }
            }
        }

        private @Nullable ContentHandler getHandler(String name, Attributes atts) {
            if ("services".equals(name)) {
                String version = atts.getValue("version");
                if ("1.0".equals(version)) {
                    LOGGER.info("Service configuration 1.0 detected");
                    return new ServicesHandler10(this.registry, this.factory);
                }
                LOGGER.info("Service configuration version unavailable, assuming 1.0");
                return new ServicesHandler10(this.registry, this.factory);
            }
            LOGGER.error("Unable to determine Berlioz configuration");
            return null;
        }
    }
}

