/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorResponseBase;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.http.HttpAutoGzipOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;

public final class HttpGeneratorResponse
extends GeneratorResponseBase
implements GeneratorResponse {
    private final HttpAutoGzipOutputStream auto;
    private final PrintWriter printer;
    private @Nullable XMLWriter xml;
    private @Nullable UniversalPrinter uni = null;
    private final OutputType outputType;

    public HttpGeneratorResponse(HttpServletResponse res, OutputType outputType, boolean compressionAllowed) throws IOException {
        this.outputType = outputType;
        this.auto = compressionAllowed ? new HttpAutoGzipOutputStream(res) : new HttpAutoGzipOutputStream(res, -1);
        this.printer = new PrintWriter(new OutputStreamWriter((OutputStream)this.auto, StandardCharsets.UTF_8));
    }

    public PrintWriter getPrinter() {
        return this.printer;
    }

    public XMLWriter getXMLWriter() {
        if (this.uni != null) {
            throw new IllegalStateException("UniversalPrinter has already been called");
        }
        if (this.xml == null) {
            this.xml = new XMLWriterImpl((Writer)this.printer, false);
        }
        return this.xml;
    }

    public UniversalPrinter getUniversalWriter() {
        if (this.xml != null) {
            throw new IllegalStateException("XMLWriter has already been called");
        }
        if (this.uni == null) {
            this.uni = UniversalPrinter.newWriter((Writer)this.printer, (OutputType)this.outputType);
        }
        return this.uni;
    }

    public boolean isEmpty() {
        this.printer.flush();
        return this.auto.size() == 0;
    }

    boolean isCompressed() {
        this.printer.flush();
        return this.auto.isCompressed();
    }

    public void close() throws IOException {
        this.auto.flush();
        this.auto.finish();
    }
}

