/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.common.util.TokenResolver;
import com.pageseeder.common.util.TokenValues;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.service.DBResolverBase;
import com.pageseeder.service.Service;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.furi.URIPattern;
import org.pageseeder.furi.URIResolveResult;
import org.pageseeder.furi.VariableBinder;
import org.pageseeder.furi.VariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpGeneratorRequest
implements GeneratorRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpGeneratorRequest.class);
    private final Map<String, String> parameters = new HashMap<String, String>();
    private @Nullable String etag = null;
    private @Nullable Database db = null;
    private @Nullable Transaction tr = null;
    private @Nullable Group group = null;
    private @Nullable Member member = null;
    private @Nullable Member authenticatedMember = null;
    private @Nullable URI uri = null;
    private @Nullable String hostname = null;
    private @Nullable String content = null;
    private byte @Nullable [] data = null;
    private boolean contentRetrieved = false;
    private Cookie @Nullable [] cookies = null;
    private @Nullable HttpServletRequest httpRequest = null;
    private @Nullable URIResolveResult result = null;

    private HttpGeneratorRequest() {
    }

    public @Nullable String getETag() {
        return this.etag;
    }

    public Database getDatabase() {
        assert (this.db != null);
        return this.db;
    }

    public Transaction getTransaction() {
        assert (this.tr != null);
        return this.tr;
    }

    public @Nullable Group getGroup() {
        return this.group;
    }

    public String getHostName() {
        assert (this.hostname != null);
        return this.hostname;
    }

    public @Nullable Member getMember() {
        return this.member;
    }

    public @Nullable Member getAuthenticatedMember() {
        if (this.authenticatedMember == null) {
            assert (this.httpRequest != null);
            Long memid = SecurityUtils.getAuthenticatedMemberId((HttpServletRequest)this.httpRequest);
            if (memid != null) {
                try {
                    assert (this.db != null);
                    this.authenticatedMember = DatabaseQuery.getMemberById((Database)this.db, (Long)memid);
                }
                catch (QueryFailedException ex) {
                    LOGGER.error("Unable to get member with ID:{}", (Object)memid, (Object)ex);
                }
            }
        }
        return this.authenticatedMember;
    }

    public @Nullable URI getURI() {
        return this.uri;
    }

    public HttpServletRequest getHttpServletRequest() {
        assert (this.httpRequest != null);
        return this.httpRequest;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public long getParameter(String name, long def) {
        String v = this.parameters.get(name);
        if (v == null || v.isEmpty()) {
            return def;
        }
        try {
            return Long.parseLong(this.parameters.get(name));
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }

    public String getParameter(String name, String def) {
        String v = this.parameters.get(name);
        return v == null || v.isEmpty() ? def : v;
    }

    public boolean getParameter(String name, boolean def) {
        String v = this.parameters.get(name);
        if (v == null || v.isEmpty()) {
            return def;
        }
        if (def) {
            return !"false".equals(v);
        }
        return "true".equals(v);
    }

    public String getParameter(Parameter parameter) {
        return this.getParameter(parameter.getName());
    }

    public @Nullable String getNonEmptyParameter(Parameter parameter) {
        String v = this.parameters.get(parameter.getName());
        return v == null || v.isEmpty() ? null : v;
    }

    public long getParameter(Parameter parameter, long def) {
        return this.getParameter(parameter.getName(), def);
    }

    public String getParameter(Parameter parameter, String def) {
        return this.getParameter(parameter.getName(), def);
    }

    public boolean getParameter(Parameter parameter, boolean def) {
        return this.getParameter(parameter.getName(), def);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Logger getLogger(@Nullable Object o) {
        return LoggerFactory.getLogger(o != null ? o.getClass() : Service.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable String getContent() throws IOException {
        if (!this.contentRetrieved) {
            assert (this.httpRequest != null);
            try (BufferedReader r = this.httpRequest.getReader();){
                this.content = IOUtils.toString((Reader)r);
            }
            finally {
                this.contentRetrieved = true;
            }
        }
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte @Nullable [] getData() throws IOException {
        if (!this.contentRetrieved) {
            assert (this.httpRequest != null);
            try (ServletInputStream in = this.httpRequest.getInputStream();){
                this.data = IOUtils.toByteArray((InputStream)in);
            }
            finally {
                this.contentRetrieved = true;
            }
        }
        return this.data;
    }

    public OutputType getOutputType() {
        assert (this.httpRequest != null);
        return WebUtilities.toOutputType((HttpServletRequest)this.httpRequest);
    }

    public @Nullable String getHeader(String name) {
        assert (this.httpRequest != null);
        return this.httpRequest.getHeader(name);
    }

    public @Nullable URIResolveResult getResult() {
        return this.result;
    }

    public static HttpGeneratorRequest make(Service service, HttpServletRequest req, Database db, Transaction tr) {
        String string;
        URIResolveResult result;
        HttpGeneratorRequest request = new HttpGeneratorRequest();
        URIPattern p = service.pattern();
        request.result = result = HttpGeneratorRequest.resolve(p, HttpGeneratorRequest.toPathInfoEnc(req), db);
        for (String variable : result.names()) {
            Iterator<Map.Entry<String, String>> o = result.get(variable);
            if (o instanceof Group && request.group == null) {
                request.group = (Group)o;
            }
            if (o instanceof URI && request.uri == null) {
                request.uri = (URI)o;
            }
            if (!(o instanceof Member) || request.member != null) continue;
            request.member = (Member)o;
        }
        LocalEnvironment localEnv = new LocalEnvironment(req, result);
        Map<String, String> parameters = service.parameters();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = TokenResolver.resolve((TokenValues)localEnv, (String)entry.getValue());
            request.parameters.put(entry.getKey(), value);
        }
        List<String> parameterTunnels = service.parameterTunnels();
        for (String prefix : parameterTunnels) {
            for (String paramName : req.getParameterMap().keySet()) {
                if (paramName == null || !paramName.startsWith(prefix)) continue;
                request.parameters.put(paramName, req.getParameter(paramName));
            }
        }
        if ("PATCH".equalsIgnoreCase(req.getMethod()) && (string = req.getContentType()) != null && string.startsWith("application/x-www-form-urlencoded")) {
            String encoding = req.getCharacterEncoding();
            if (encoding == null) {
                encoding = StandardCharsets.UTF_8.name();
            }
            try (Scanner scanner = new Scanner((InputStream)req.getInputStream(), encoding).useDelimiter("&");){
                while (scanner.hasNext()) {
                    String parameter = scanner.next();
                    int eq = parameter.indexOf(61);
                    String name = eq == -1 ? parameter : URLDecoder.decode(parameter.substring(0, eq), encoding);
                    String value = eq == -1 ? "" : URLDecoder.decode(parameter.substring(eq + 1), encoding);
                    request.parameters.put(name, value);
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                LOGGER.warn("Ignoring URL-encoded body from PATCH request: {}", (Object)ex.getMessage());
            }
        }
        request.db = db;
        request.tr = tr;
        request.etag = HttpRequests.getETagForUncompressed((String)req.getHeader("If-None-Match"));
        request.hostname = req.getServerName();
        request.cookies = req.getCookies();
        request.httpRequest = req;
        return request;
    }

    static String toPathInfoEnc(HttpServletRequest req) {
        String prefix = req.getContextPath() + req.getServletPath();
        String path = req.getRequestURI();
        int index = path.indexOf(";jsessionid=");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return path.substring(prefix.length()).replaceAll("(\\.xml|\\.json|\\.csv)$", "");
    }

    private static URIResolveResult resolve(URIPattern p, String uri, Database db) {
        VariableBinder bindings = new VariableBinder();
        bindings.bindType("group", (VariableResolver)new GroupResolver(db));
        bindings.bindType("uri", (VariableResolver)new URIResolver(db));
        bindings.bindType("member", (VariableResolver)new MemberResolver(db));
        bindings.bindName("name", (VariableResolver)new NameResolver());
        org.pageseeder.furi.URIResolver resolver = new org.pageseeder.furi.URIResolver(uri);
        return resolver.resolve(p, bindings);
    }

    private static boolean isMaybeID(String value) {
        return Strings.isDigits((String)value) && value.charAt(0) != '0';
    }

    private static String normalizeValue(String value) {
        return value.indexOf(126) == 0 ? value.substring(1) : value;
    }

    private static final class NameResolver
    implements VariableResolver {
        private NameResolver() {
        }

        public boolean exists(String value) {
            return true;
        }

        public String resolve(String value) {
            return HttpGeneratorRequest.normalizeValue(value);
        }
    }

    private static final class MemberResolver
    extends DBResolverBase<Member> {
        public MemberResolver(Database db) {
            super(db);
        }

        @Override
        protected @Nullable Member get(Database db, String value) {
            Member member = null;
            try {
                if (HttpGeneratorRequest.isMaybeID(value)) {
                    Long id = Long.parseLong(value);
                    member = DatabaseQuery.getMemberById((Database)db, (Long)id);
                } else {
                    String usernameOrEmail = HttpGeneratorRequest.normalizeValue(value);
                    member = usernameOrEmail.indexOf(64) > 0 ? DatabaseQuery.getMemberByEmail((Database)db, (String)usernameOrEmail) : DatabaseQuery.getMemberByUsername((Database)db, (String)usernameOrEmail);
                }
            }
            catch (QueryFailedException ex) {
                LOGGER.warn("Error while looking for Member '{}' in database: {}", (Object)value, (Object)ex.getMessage());
            }
            return member;
        }
    }

    private static final class URIResolver
    extends DBResolverBase<URI> {
        public URIResolver(Database db) {
            super(db);
        }

        @Override
        protected @Nullable URI get(Database db, String value) {
            URI uri = null;
            try {
                if (HttpGeneratorRequest.isMaybeID(value)) {
                    Long id = Long.parseLong(value);
                    uri = DatabaseQuery.getURIById((Database)db, (Long)id);
                } else {
                    String docid = HttpGeneratorRequest.normalizeValue(value);
                    String host = GlobalSettings.get((String)"webSiteAddress");
                    uri = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)host, (String)docid);
                }
            }
            catch (QueryFailedException ex) {
                LOGGER.warn("Error while looking for Group '{}' in database: {}", (Object)value, (Object)ex.getMessage());
            }
            return uri;
        }
    }

    private static final class GroupResolver
    extends DBResolverBase<Group> {
        public GroupResolver(Database db) {
            super(db);
        }

        @Override
        protected @Nullable Group get(Database db, @Nullable String value) {
            Group group = null;
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                if (HttpGeneratorRequest.isMaybeID(value)) {
                    Long id = Long.parseLong(value);
                    group = DatabaseQuery.getGroupById((Database)db, (Long)id);
                } else {
                    String name = HttpGeneratorRequest.normalizeValue(value);
                    group = DatabaseQuery.getGroupByName((Database)db, (String)name);
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.warn("Assumed '{}' was a Group ID but it was not: {}", (Object)value, (Object)ex.getMessage());
            }
            catch (QueryFailedException ex) {
                LOGGER.warn("Error while looking for Group '{}' in database: {}", (Object)value, (Object)ex.getMessage());
            }
            if (group != null && "public".equals(group.getName())) {
                return null;
            }
            return group;
        }
    }

    private static final class LocalEnvironment
    implements TokenValues {
        private final HttpServletRequest request;
        private final URIResolveResult result;

        public LocalEnvironment(HttpServletRequest req, URIResolveResult res) {
            this.request = req;
            this.result = res;
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public String[] getParameterValues(String name) {
            return this.request.getParameterValues(name);
        }

        public @Nullable String getProperty(String name) {
            return null;
        }

        public @Nullable String getVariable(String name) {
            Object o = this.result.get(name);
            if (o instanceof String) {
                return (String)o;
            }
            return null;
        }
    }
}

