/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.resource;

import com.pageseeder.resource.CacheEntry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.jdt.annotation.Nullable;

public final class ResourceCache {
    protected static final int CACHE_MAX_SIZE = 10240;
    private static final int MAX_ALLOCATE_ITERATIONS = 20;
    private static final long DESIRED_ENTRY_ACCESS_RATIO = 3L;
    private static final int SPARE_NOT_FOUND_ENTRIES = 500;
    private final Random random = new Random();
    private CacheEntry[] cache = new CacheEntry[0];
    private final Map<String, CacheEntry> notFoundCache = new HashMap<String, CacheEntry>();
    private int cacheSize = 0;
    private long accessCount = 0L;
    private long hitsCount = 0L;

    public long getAccessCount() {
        return this.accessCount;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public long getHitsCount() {
        return this.hitsCount;
    }

    public boolean allocate(int space) {
        int toFree = space - (10240 - this.cacheSize);
        if (toFree <= 0) {
            return true;
        }
        toFree += 512;
        int size = this.notFoundCache.size();
        if (size > 500) {
            this.notFoundCache.clear();
            this.cacheSize -= size;
            toFree -= size;
        }
        if (toFree <= 0) {
            return true;
        }
        int attempts = 0;
        int entriesFound = 0;
        long totalSpace = 0L;
        int[] toRemove = new int[20];
        while (toFree > 0) {
            if (attempts == 20) {
                return false;
            }
            if (toFree > 0) {
                int entryPos = -1;
                boolean unique = false;
                while (!unique) {
                    unique = true;
                    entryPos = this.random.nextInt(this.cache.length);
                    for (int i = 0; i < entriesFound; ++i) {
                        if (toRemove[i] != entryPos) continue;
                        unique = false;
                    }
                }
                long entryAccessRatio = this.cache[entryPos].accessCount * 100L / this.accessCount;
                if (entryAccessRatio < 3L) {
                    toRemove[entriesFound] = entryPos;
                    totalSpace += (long)this.cache[entryPos].size;
                    toFree -= this.cache[entryPos].size;
                    ++entriesFound;
                }
            }
            ++attempts;
        }
        Arrays.sort(toRemove, 0, entriesFound);
        CacheEntry[] newCache = new CacheEntry[this.cache.length - entriesFound];
        int pos = 0;
        int n = -1;
        if (entriesFound > 0) {
            n = toRemove[0];
            for (int i = 0; i < this.cache.length; ++i) {
                if (i == n) {
                    if (pos + 1 < entriesFound) {
                        n = toRemove[pos + 1];
                        ++pos;
                        continue;
                    }
                    ++pos;
                    n = -1;
                    continue;
                }
                newCache[i - pos] = this.cache[i];
            }
        }
        this.cache = newCache;
        this.cacheSize = (int)((long)this.cacheSize - totalSpace);
        return true;
    }

    public @Nullable CacheEntry lookup(String name) {
        CacheEntry cacheEntry = null;
        CacheEntry[] currentCache = this.cache;
        ++this.accessCount;
        int pos = ResourceCache.find(currentCache, name);
        if (pos != -1 && name.equals(currentCache[pos].getName())) {
            cacheEntry = currentCache[pos];
        }
        if (cacheEntry == null) {
            try {
                cacheEntry = this.notFoundCache.get(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cacheEntry != null) {
            ++this.hitsCount;
        }
        return cacheEntry;
    }

    public void load(CacheEntry entry) {
        if (entry.exists()) {
            if (this.insertCache(entry)) {
                this.cacheSize += entry.size;
            }
        } else {
            int sizeIncrement = this.notFoundCache.get(entry.getName()) == null ? 1 : 0;
            this.notFoundCache.put(entry.getName(), entry);
            this.cacheSize += sizeIncrement;
        }
    }

    public boolean unload(String name) {
        CacheEntry removedEntry = this.removeCache(name);
        if (removedEntry != null) {
            this.cacheSize -= removedEntry.size;
            return true;
        }
        if (this.notFoundCache.remove(name) != null) {
            --this.cacheSize;
            return true;
        }
        return false;
    }

    private static int find(CacheEntry[] map, String name) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compareTo(map[0].getName()) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            int result;
            if ((result = name.compareTo(map[i = b + a >>> 1].getName())) > 0) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compareTo(map[b].getName());
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private boolean insertCache(CacheEntry newElement) {
        CacheEntry[] oldCache = this.cache;
        int pos = ResourceCache.find(oldCache, newElement.getName());
        if (pos != -1 && newElement.getName().equals(oldCache[pos].getName())) {
            return false;
        }
        CacheEntry[] newCache = new CacheEntry[this.cache.length + 1];
        System.arraycopy(oldCache, 0, newCache, 0, pos + 1);
        newCache[pos + 1] = newElement;
        System.arraycopy(oldCache, pos + 1, newCache, pos + 2, oldCache.length - pos - 1);
        this.cache = newCache;
        return true;
    }

    private @Nullable CacheEntry removeCache(String name) {
        CacheEntry[] oldCache = this.cache;
        int pos = ResourceCache.find(oldCache, name);
        if (pos != -1 && name.equals(oldCache[pos].getName())) {
            CacheEntry[] newCache = new CacheEntry[this.cache.length - 1];
            System.arraycopy(oldCache, 0, newCache, 0, pos);
            System.arraycopy(oldCache, pos + 1, newCache, pos, oldCache.length - pos - 1);
            this.cache = newCache;
            return oldCache[pos];
        }
        return null;
    }
}

