/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.resource;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.http.EntityInfo;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Resource;
import com.pageseeder.common.io.ResourceCompressor;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.resource.ResourceInfo;
import com.pageseeder.utils.MemberTempFiles;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemberResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 7493320421950876142L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberResourceServlet.class);
    private static final int READ_BUFFER = 2048;

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.serveResource(request, response, true);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.serveResource(request, response, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    private void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) {
        WebRequest wr = new WebRequest(request, response);
        String relativePath = wr.getParameter("path", request.getPathInfo());
        if (relativePath.contains("..")) {
            wr.sendError(400, "Illegal path");
            return;
        }
        int secondSlash = relativePath.indexOf(47, 1);
        if (secondSlash == -1) {
            wr.sendError(400, "Group is missing from the path");
            return;
        }
        String group = relativePath.substring(1, secondSlash);
        File file = this.fetchResourceFile(wr, group, relativePath = relativePath.substring(1 + secondSlash));
        if (file == null) {
            return;
        }
        String resourcePath = Files.safePath((File)new File(Settings.getDocumentPath()), (File)file);
        if (!file.exists() && !file.isFile()) {
            wr.sendError(404, "Resource not found");
            LOGGER.debug("Resource not found: {}", (Object)resourcePath);
            return;
        }
        if (resourcePath.endsWith("/") || resourcePath.endsWith("\\")) {
            wr.sendError(404, "Illegal path ending");
            LOGGER.debug("Illegal path ending: {}", (Object)resourcePath);
            return;
        }
        String contentType = MemberResourceServlet.getContentType(file.getName());
        if (contentType == null) {
            wr.sendError(400, "Unrecognised media type");
            return;
        }
        ResourceInfo info = new ResourceInfo();
        info.setContentLength(file.length());
        info.setLastModified(file.lastModified());
        info.setName(file.getName());
        info.setMimeType(contentType);
        response.setHeader("Cache-Control", "no-cache");
        if (!HttpRequests.checkIfHeaders((HttpServletRequest)request, (HttpServletResponse)response, (EntityInfo)info)) {
            return;
        }
        if (request.getHeader("Range") != null) {
            response.setHeader("Accept-Ranges", "none");
        }
        long contentLength = info.getContentLength();
        boolean includeContent = content;
        if (contentLength == 0L) {
            includeContent = false;
        }
        response.setContentType(contentType);
        if (contentLength >= 0L) {
            HttpRequests.setContentLength((HttpServletResponse)response, (long)contentLength);
        }
        if (includeContent) {
            this.writeResponse(wr, file, contentType, info);
        }
        if (content && !file.delete()) {
            LOGGER.warn("Failed to delete member resource {}, it should be deleted when the JVM exits", (Object)file.getAbsolutePath());
            file.deleteOnExit();
        }
    }

    private void writeResponse(WebRequest wr, File file, String contentType, ResourceInfo info) {
        HttpServletResponse response = wr.response();
        try {
            ServletOutputStream out = response.getOutputStream();
            Resource resource = new Resource(file);
            if (HttpRequests.isCompressible((String)contentType) && HttpRequests.acceptsGZipCompression((HttpServletRequest)wr.request())) {
                response.setHeader("Vary", "Accept-Encoding");
                boolean loaded = resource.loadContent();
                byte[] content = resource.getContent();
                if (loaded && content != null) {
                    resource = new Resource(file);
                    resource.setContent(content);
                    boolean ok = ResourceCompressor.compress((Resource)resource);
                    if (ok) {
                        content = resource.getContent();
                        assert (content != null);
                        response.setIntHeader("Content-Length", content.length);
                        response.setHeader("Content-Encoding", "gzip");
                        String etag = info.getETag();
                        if (etag != null) {
                            response.setHeader("ETag", HttpRequests.getETagForGZip((String)etag));
                        }
                    }
                }
            }
            this.copy(resource, out);
        }
        catch (IOException ex) {
            wr.sendError((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable File fetchResourceFile(WebRequest wr, String groupName, String relativePath) {
        Database db = wr.getDatabase();
        if (db == null) {
            return null;
        }
        File file = null;
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Permissions perm = new Permissions();
            Group group = GroupRule.getGroup((Database)db, (String)groupName);
            if (!PermissionManager.check((HttpServletRequest)wr.request(), (HttpServletResponse)wr.response(), (Database)db, (Permissions)perm, (PermissionCheck)new ViewGroupCheck(group))) {
                tr.abort();
                File file2 = null;
                return file2;
            }
            Long memberId = perm.getMemberId();
            assert (memberId != null);
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
            assert (member != null);
            file = Files.safeDescendantFile((File)MemberTempFiles.getTempFolder(member, group), (String)relativePath);
            tr.commit();
        }
        catch (StartTransactionException ex) {
            wr.sendError((Exception)((Object)ex));
        }
        catch (IllegalArgumentException ex) {
            tr.abort();
            wr.sendError(400, "Invalid path");
        }
        catch (Exception ex) {
            tr.abort();
            wr.sendError(ex);
        }
        finally {
            db.close();
            db = null;
        }
        return file;
    }

    private void copy(Resource resource, ServletOutputStream out) throws IOException {
        byte[] buffer = resource.getContent();
        if (buffer != null) {
            out.write(buffer, 0, buffer.length);
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream(resource.streamContent(), 2048);){
            ((InputStream)in).transferTo((OutputStream)out);
        }
    }

    private static @Nullable String getContentType(String name) {
        int x = name.lastIndexOf(46);
        String extension = x >= 0 ? name.substring(x + 1) : "html";
        return Settings.get((SettingsFile)SettingsFile.MIME, (String)extension);
    }
}

