/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.GetCollectionException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.publish.PublishLogMessage;
import com.pageseeder.publish.PublishLogger;
import com.pageseeder.publish.PublishResponseHandler;
import com.pageseeder.publish.PublisherUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class Publisher {
    private static final int BEHAVIOR_SIZE = 3;
    private static final int BUFFER_SIZE = 2048;
    private final PublisherAction action;
    private static final Logger logger = LoggerFactory.getLogger(Publisher.class);
    private String sourceProjectName = null;
    private String sourceActionType = null;
    private String sourceDoctype = null;
    private String sourceUrltype = null;
    private String sourceType = null;
    private String jsessionid = null;
    private String processID = null;
    private String username = null;
    private String userID = null;
    private String userFirstname = null;
    private String userSurname = null;
    private String userToken = null;
    private String antiCSRFToken = null;
    private List<Long> uriIds = null;
    private URI uri;
    private Publication publication;
    private Group group;
    private String response = null;
    private Stack<PublishLogMessage> messages = new Stack();
    private String target = null;
    private final Map<String, List<String>> parameters = new ConcurrentHashMap<String, List<String>>();
    private final String sitePrefix;
    private UniversalPrinter output;
    private boolean isUrl = false;

    public Publisher(PublisherAction theaction) {
        this.action = theaction;
        this.sitePrefix = GlobalSettings.getSitePrefix();
        this.setParameter("ps-host", GlobalSettings.get((String)"publishEngineUrl") == null ? "localhost" : GlobalSettings.get((String)"webSiteAddress"));
        this.setParameter("ps-port", GlobalSettings.getString((String)"apiPort", (String)GlobalSettings.get((String)"webSitePort")));
        this.setParameter("ps-servletPrefix", GlobalSettings.get((String)"servletPrefix"));
        this.setParameter("ps-sitePrefix", this.sitePrefix);
    }

    public void setConfigProjectName(String projectname) {
        this.sourceProjectName = projectname;
    }

    public void setActionType(String actiontype) {
        this.sourceActionType = actiontype;
    }

    public void setSourceDocumentType(String doctype) {
        this.sourceDoctype = doctype;
    }

    public void setSourceURlType(String urltype) {
        this.sourceUrltype = urltype;
    }

    public void setSourceType(String type) {
        this.sourceType = type;
    }

    public void setProcessID(String theprocessID) {
        this.processID = theprocessID;
    }

    public void setJsessionid(String thejsessionid) {
        this.jsessionid = thejsessionid;
    }

    public void setGroup(Group thegroup) {
        this.group = thegroup;
    }

    public void setUri(URI theuri, Group thegroup, Database db) throws QueryFailedException {
        this.uri = theuri;
        this.publication = DatabaseQuery.getPublicationByRootURI((Database)db, (URI)theuri, (boolean)false);
        this.isUrl = URIs.isExternal((URI)theuri);
    }

    public String getProcessID() {
        return this.processID;
    }

    public String getResponse() {
        return this.response;
    }

    public Stack<PublishLogMessage> getPublishMessages() {
        return this.messages;
    }

    public void setUsername(String theUsername) {
        this.username = theUsername;
    }

    public void setUserID(String theID) {
        this.userID = theID;
    }

    public void setUserFirstname(String theFirstname) {
        this.userFirstname = theFirstname;
    }

    public void setUserSurname(String theSurname) {
        this.userSurname = theSurname;
    }

    public void setUserToken(String theToken) {
        this.userToken = theToken;
    }

    public void setAntiCSRFToken(String theToken) {
        this.antiCSRFToken = theToken;
    }

    public void setTarget(String t) {
        this.target = t;
    }

    public void addUriId(Long uriid) {
        if (this.uriIds == null) {
            this.uriIds = new ArrayList<Long>();
        }
        if (!this.uriIds.contains(uriid)) {
            this.uriIds.add(uriid);
        }
    }

    public void setBatchUriIds(List<Long> ids) {
        if (ids != null) {
            this.uriIds = new ArrayList<Long>();
            this.uriIds.addAll(ids);
        } else {
            this.uriIds = null;
        }
    }

    public void setOutput(UniversalPrinter out) {
        this.output = out;
    }

    public void setParameter(String pname, String pvalue) {
        if (pname == null || pvalue == null || "action".equals(pname) || "type".equals(pname) || "script".equals(pname) || "ps-jsessionid".equals(pname)) {
            return;
        }
        List<String> alreadythere = this.parameters.get(pname);
        if (alreadythere == null) {
            alreadythere = new ArrayList<String>();
        }
        alreadythere.add(pvalue);
        this.parameters.put(pname, alreadythere);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        this.calculateSourceType();
        if (this.action == PublisherAction.PUBLISH) {
            if (this.uri == null && this.group == null && this.uriIds == null || this.target == null) {
                throw new IllegalStateException("Missing Parameters: you need to specify a uri or a group and a target.");
            }
            if (this.processID == null) {
                this.processID = "id-" + System.currentTimeMillis();
            }
            PublishLogMessage msg = PublishLogMessage.newInstance("start", null, this.processID, this.group);
            msg.setURIPath(this.uri == null ? null : this.uri.getDecodedPath());
            msg.setContent(this.buildStartLogMessage());
            msg.setTitle(this.getTitle());
            PublishLogger.getInstance().info(msg);
        } else if (this.action == PublisherAction.CHECK && this.processID == null && this.uri == null && this.group == null) {
            throw new IllegalStateException("Missing Parameters: you need to specify a uri or a group.");
        }
        this.addURIDetails();
        this.addGroupDetails();
        this.addParameters();
        logger.debug("New {} with id {}", (Object)this.getAction(), (Object)this.getProcessID());
        if (GlobalSettings.get((String)"publishEngineUrl") == null) {
            this.setParameter("ps-documentsRoot", Settings.getDocumentPath());
        }
        HttpURLConnection con = (HttpURLConnection)new URL(PublisherUtils.getPublisherURL()).openConnection();
        con.setDoOutput(true);
        con.setInstanceFollowRedirects(false);
        con.setRequestMethod("POST");
        con.setDoInput(true);
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        con.connect();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(con.getOutputStream(), StandardCharsets.UTF_8));){
            writer.write("type=ant&action=" + this.getAction() + (String)(this.jsessionid != null ? "&ps-jsessionid=" + this.jsessionid : ""));
            for (String pname : this.parameters.keySet()) {
                List<String> pvalues = this.parameters.get(pname);
                for (String pvalue : pvalues) {
                    writer.write("&" + pname + "=" + URLCoder.encode((String)pvalue));
                    logger.debug("Sending parameter {} with value {}", (Object)pname, (Object)pvalue);
                }
            }
        }
        int code = con.getResponseCode();
        InputStream inputStream = code == 200 ? con.getInputStream() : con.getErrorStream();
        StringBuilder out = new StringBuilder();
        byte[] buffer = new byte[2048];
        try {
            int read;
            while ((read = inputStream.read(buffer)) != -1) {
                out.append(new String(buffer, 0, read, StandardCharsets.UTF_8));
            }
        }
        finally {
            inputStream.close();
        }
        if (code != 200) {
            throw new IOException("Request to Publish Engine failed: " + con.getResponseMessage() + " (" + out.toString() + ")");
        }
        try {
            PublishResponseHandler handler = PublishLogger.getInstance().createPublishResponseHandler(this.getProcessID());
            if (this.output != null) {
                this.response = out.toString();
                handler.parse(this.response, this.output);
            } else {
                this.response = handler.parse(out.toString());
            }
            this.messages = handler.getMessages();
        }
        catch (SAXException ex) {
            logger.error("Failed to parse publisher response", (Throwable)ex);
            this.response = out.toString();
            PublishLogMessage msg1 = PublishLogMessage.newInstance("info", null, this.processID, this.group);
            msg1.setContent("Publisher response was: " + this.response);
            this.messages.add(msg1);
            PublishLogMessage msg2 = PublishLogMessage.newInstance("fail", null, this.processID, this.group);
            msg2.setContent("Failed to parse publisher response, see logs for more details");
            this.messages.add(msg2);
        }
    }

    private String buildStartLogMessage() {
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            Object ext;
            xml.openElement("script", false);
            xml.attribute("actiontype", this.sourceActionType);
            if (!Strings.isEmpty((String)this.sourceType)) {
                xml.attribute("sourcetype", this.sourceType);
            }
            if (!Strings.isEmpty((String)this.sourceUrltype)) {
                xml.attribute("urltype", this.sourceUrltype);
            } else if (!Strings.isEmpty((String)this.sourceDoctype)) {
                xml.attribute("documenttype", this.sourceDoctype);
            } else if (this.uri != null && !((String)(ext = URIRule.getFilename((URI)this.uri)[1])).isEmpty()) {
                xml.attribute("extension", ((String)ext).substring(1));
            }
            xml.attribute("target", this.target);
            xml.closeElement();
            xml.openElement("parameters", true);
            for (String pname : this.parameters.keySet()) {
                if (!pname.startsWith("ps-param-")) continue;
                List<String> pvalues = this.parameters.get(pname);
                StringBuilder values = new StringBuilder();
                for (int i = 0; i < pvalues.size(); ++i) {
                    if (i != 0) {
                        values.append(',');
                    }
                    values.append(pvalues.get(i));
                }
                xml.openElement("parameter", false);
                xml.attribute("name", pname.substring(9));
                xml.attribute("value", values.toString());
                xml.closeElement();
            }
            xml.closeElement();
        }
        catch (IOException ex) {
            return "Start of publishing";
        }
        return xml.toString();
    }

    private @Nullable String getAction() {
        if (this.action == PublisherAction.CANCEL) {
            return "cancel";
        }
        if (this.action == PublisherAction.PUBLISH) {
            return "publish";
        }
        if (this.action == PublisherAction.PEEK) {
            return "peek";
        }
        if (this.action == PublisherAction.CHECK) {
            return "check";
        }
        if (this.action == PublisherAction.CHECKALL) {
            return "checkall";
        }
        return null;
    }

    private String getTitle() {
        Object title = "Publish";
        if (this.sourceActionType != null) {
            title = String.valueOf(this.sourceActionType.charAt(0)).toUpperCase() + this.sourceActionType.substring(1);
        }
        if (this.uri != null) {
            title = (String)title + ("folder".equals(this.uri.getType()) ? " of folder " : " of document ") + this.uri.getDisplayTitle() + " (" + this.uri.getId() + ")";
        } else if (this.group != null) {
            title = (String)title + " group " + this.group.getName();
        }
        return title;
    }

    private void addGroupDetails() {
        if (this.group != null) {
            String groupname = this.group.getName();
            this.setParameter("ps-groupName", groupname);
            this.setParameter("ps-groupId", this.group.getId().toString());
            String group_path = this.sitePrefix + "/" + this.group.getName().replace('-', '/');
            this.setParameter("ps-groupFolder", group_path);
            this.setParameter("ps-groupFolderNoPrefix", group_path.substring(this.sitePrefix.length()));
            GroupURI guri = null;
            try {
                guri = this.group.getFlags() != null && this.group.getFlags().contains("f") ? GroupRule.getFolderGroupURI((Group)this.group) : GroupURIRule.getDefaultGroupURI((Group)this.group);
            }
            catch (GetCollectionException e) {
                logger.error("Failed to load default Group URI", (Throwable)e);
            }
            if (guri != null) {
                this.setParameter("ps-groupScheme", guri.getScheme());
                this.setParameter("ps-groupHost", guri.getHost().getName());
                this.setParameter("ps-groupPort", guri.getPort().toString());
            }
            String globalTemplate = GlobalSettings.getGlobalTemplate();
            this.setParameter("ps-globalTemplate", globalTemplate);
            String template = this.group.getOwnerDirectory();
            if (template == null) {
                template = globalTemplate;
            }
            if (template != null) {
                this.setParameter("ps-groupTemplate", template);
            }
        }
    }

    private void addURIDetails() {
        if (this.uri != null) {
            String group_path;
            boolean isUrl = URIs.isExternal((URI)this.uri);
            String styleConfig = URIRule.getStyleConfig((URI)this.uri);
            if (styleConfig != null) {
                this.setParameter(isUrl ? "ps-urlType" : "style-config", styleConfig);
            }
            if (this.uri.getType() != null) {
                this.setParameter("uri-type", this.uri.getType());
            }
            this.setParameter("ps-uriId", this.uri.getId().toString());
            this.setParameter("ps-uriScheme", this.uri.getScheme());
            this.setParameter("ps-uriHost", this.uri.getHost().getName());
            this.setParameter("ps-uriPort", this.uri.getPort().toString());
            String uripath = this.uri.getDecodedPath();
            this.setParameter("ps-uriPath", uripath);
            this.setParameter("ps-uriPathNoPrefix", uripath.substring(this.sitePrefix.length()));
            String string = group_path = this.group != null ? this.sitePrefix + "/" + this.group.getName().replace('-', '/') : null;
            if (!isUrl && group_path != null) {
                this.setParameter("ps-uriPathNoGroup", uripath.substring(group_path.length()));
            }
            if (this.uri.getDocID() != null) {
                this.setParameter("ps-uriDocumentId", this.uri.getDocID());
            }
            if (this.publication != null) {
                this.setParameter("ps-uriPublicationId", this.publication.getId());
                this.setParameter("ps-uriPublicationType", this.publication.getType());
            } else if (!isUrl) {
                this.setParameter("ps-uriPublicationType", "default");
            }
            int i = uripath.lastIndexOf(47);
            if (i != -1) {
                this.setParameter("ps-uriFolder", uripath.substring(0, i));
                if (!isUrl) {
                    this.setParameter("ps-uriFolderNoPrefix", uripath.substring(this.sitePrefix.length(), i));
                    if (group_path != null && uripath.startsWith(group_path) && group_path.length() <= i) {
                        String p = uripath.substring(group_path.length(), i);
                        this.setParameter("ps-uriFolderNoGroup", p.length() == 0 ? "" : p);
                    } else {
                        this.setParameter("ps-uriFolderNoGroup", "");
                    }
                }
                String filename = uripath.substring(i + 1);
                this.setParameter("ps-uriFilename", filename);
                int j = uripath.lastIndexOf(46);
                if (j != -1 && i < j) {
                    this.setParameter("ps-uriFilenameNoExt", uripath.substring(i + 1, j));
                    this.setParameter("ps-uriExtension", uripath.substring(j + 1));
                } else {
                    this.setParameter("ps-uriFilenameNoExt", filename);
                    this.setParameter("ps-uriExtension", "");
                }
            }
        } else if (this.uriIds != null && !this.uriIds.isEmpty()) {
            this.setParameter("ps-batchIds", this.uriIds.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
    }

    private void addParameters() {
        this.setParameter("ps-processId", this.processID);
        this.setParameter("ps-username", this.username);
        this.setParameter("ps-userId", this.userID);
        this.setParameter("ps-userFirstname", this.userFirstname);
        this.setParameter("ps-userSurname", this.userSurname);
        this.setParameter("ps-userToken", this.userToken);
        this.setParameter("ps-anticsrftoken", this.antiCSRFToken);
        this.setParameter("source-projectname", this.sourceProjectName);
        this.setParameter("source-actiontype", this.sourceActionType);
        this.setParameter("source-documenttype", this.sourceDoctype);
        this.setParameter("target", this.target);
        if (this.sourceType != null) {
            this.setParameter("source-type", this.sourceType);
            if ("url".equals(this.sourceType)) {
                this.setParameter("source-urltype", this.sourceUrltype == null ? "default" : this.sourceUrltype);
            }
        }
    }

    private void calculateSourceType() {
        if (this.sourceType == null) {
            if (this.isUrl) {
                this.sourceType = "url";
            } else if (this.uri != null) {
                this.sourceType = "folder".equals(this.uri.getType()) ? "folder" : "document";
            } else if (this.uriIds != null) {
                this.sourceType = "batch";
            } else if (this.group != null) {
                this.sourceType = "group";
            }
        }
    }

    public static enum PublisherAction {
        PUBLISH,
        CHECK,
        CANCEL,
        CHECKALL,
        PEEK;

    }
}

