/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.xml.XMLUtils;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PublishLogMessage
implements XMLWritable,
XLoggable {
    private final String jobid;
    private final String groupid;
    private final String group;
    private final String type;
    private final String target;
    private @Nullable String uripath = null;
    private @Nullable String username = null;
    private long started = -1L;
    private @Nullable String progress = null;
    private @Nullable String stacktrace = null;
    private @Nullable String title = null;
    private @Nullable String content = null;

    @Deprecated
    public PublishLogMessage(String type, String target, String id, String gpid, String group) {
        this.jobid = id;
        this.groupid = gpid != null ? gpid.toString() : null;
        this.group = group;
        this.target = target;
        this.type = type;
    }

    private PublishLogMessage(String type, String target, String id, Group group) {
        this.jobid = id;
        this.groupid = group != null ? group.getId().toString() : null;
        this.group = group != null ? group.getName() : null;
        this.target = target;
        this.type = type;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public String getJobid() {
        return this.jobid;
    }

    public Long getGroupID() {
        return this.groupid != null ? Long.valueOf(this.groupid) : null;
    }

    public String getUsername() {
        return this.username;
    }

    public long getStarted() {
        return this.started;
    }

    public String getTarget() {
        return this.target;
    }

    public String getEventType() {
        return this.type;
    }

    public String getUripath() {
        return this.uripath;
    }

    public void setStacktrace(String stacktrace) {
        this.stacktrace = stacktrace;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setURIPath(String uripath) {
        this.uripath = uripath;
    }

    public void setUser(String username) {
        this.username = username;
    }

    public void setStarted(long started) {
        this.started = started;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public String getGroup() {
        return this.group;
    }

    public String getTicket() {
        return this.jobid;
    }

    public String getUser() {
        return this.username;
    }

    public String getTitle() {
        return this.title;
    }

    public XLoggable.TYPE getType() {
        return "start".equals(this.type) ? XLoggable.TYPE.START : ("complete".equals(this.type) || "fail".equals(this.type) || "cancel".equals(this.type) ? XLoggable.TYPE.END : null);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("publish");
        if (this.type != null) {
            xml.element("type", this.type.equals("cancel") ? "warning" : this.type);
        }
        if (this.groupid != null) {
            xml.element("groupid", this.groupid);
        }
        if (this.jobid != null) {
            xml.element("jobid", this.jobid);
        }
        if (this.username != null) {
            xml.element("username", this.username);
        }
        if (this.started != -1L) {
            xml.element("started", String.valueOf(this.started));
        }
        if (this.uripath != null) {
            xml.element("uripath", this.uripath);
        }
        if (this.target != null) {
            xml.element("target", this.target);
        }
        if (this.content != null) {
            xml.openElement("message");
            xml.writeXML(this.content);
            xml.closeElement();
        }
        if (this.stacktrace != null) {
            xml.element("stacktrace", this.stacktrace);
        }
        xml.closeElement();
    }

    public String toXML() {
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            this.toXML((XMLWriter)xml);
        }
        catch (IOException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
        return xml.toString();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.type != null) {
            out.append('[').append(this.type).append(']');
        }
        if (this.content != null) {
            out.append(' ').append(this.content);
        }
        out.append(" (");
        if (this.jobid != null) {
            out.append(" J:").append(this.jobid);
        }
        if (this.groupid != null) {
            out.append(" G:").append(this.groupid);
        }
        if (this.username != null) {
            out.append(" U:").append(this.username);
        }
        if (this.started != -1L) {
            out.append(" S:").append(this.started);
        }
        if (this.target != null) {
            out.append(" T:").append(this.target);
        }
        if (this.uripath != null) {
            out.append(" P:").append(this.uripath);
        }
        out.append(')');
        if (this.stacktrace != null) {
            out.append('\n');
            out.append(this.stacktrace);
        }
        return out.toString();
    }

    public void toXMLLog(Appendable xml) throws IOException {
        xml.append("<publish");
        if (this.type != null) {
            PublishLogMessage.attribute(xml, "type", this.type.equals("cancel") ? "warning" : this.type);
        }
        if (this.uripath != null) {
            PublishLogMessage.attribute(xml, "uripath", this.uripath);
        }
        if (this.started != -1L) {
            PublishLogMessage.attribute(xml, "started", String.valueOf(this.started));
        }
        if (this.target != null) {
            PublishLogMessage.attribute(xml, "target", this.target);
        }
        xml.append('>');
        if (this.content != null) {
            xml.append("<message>");
            xml.append(this.content);
            xml.append("</message>");
        }
        if (this.stacktrace != null) {
            xml.append("<stacktrace>");
            xml.append(XMLUtils.escapeText((String)this.stacktrace));
            xml.append("</stacktrace>");
        }
        xml.append("</publish>");
    }

    public static PublishLogMessage newInstance(String type, String target, String id, Group group) {
        return new PublishLogMessage(type, target, id, group);
    }

    private static void attribute(Appendable xml, String name, String value) throws IOException {
        xml.append(' ');
        xml.append(name).append('=').append('\"');
        xml.append(XMLUtils.escapeAttValue((String)value));
        xml.append('\"');
    }
}

