/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.publish.PublishEvent;
import com.pageseeder.publish.PublishScheduler;
import com.pageseeder.publish.PublishSchedulerThread;
import java.io.IOException;

@Requires(parameters={"action", "eventid"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class PublishEventAction
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String id = req.getParameter("eventid");
        String action = req.getParameter("action");
        if (!("pause".equals(action) || "continue".equals(action) || "start".equals(action))) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid action '" + action + "', only 'start', 'pause' and 'continue' are supported.");
            return;
        }
        PublishEvent event = null;
        for (PublishEvent ev : PublishScheduler.getInstance().getEvents()) {
            if (!id.equals(ev.getID())) continue;
            event = ev;
            break;
        }
        if (event == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Invalid ID " + id);
        } else {
            if ("start".equals(action)) {
                event.setManual(true);
                PublishSchedulerThread.publishEvent(event);
            } else {
                event.setPaused("pause".equals(action));
            }
            UniversalPrinter out = res.getUniversalWriter();
            out.write((UniversallyPrintable)event);
            out.flush();
        }
    }
}

