/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.publish.PublishJobDetails;
import com.pageseeder.publish.PublishJobs;
import com.pageseeder.publish.Publisher;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, member=true, parameters={"jobid"})
public final class Check
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        PublishJobDetails job = PublishJobs.getJob(req.getParameter((Parameter)StandardParameters.jobid));
        if (job == null) {
            return new NoCheck();
        }
        Member m = DatabaseQuery.getMemberByUsername((Database)req.getDatabase(), (String)job.getUsername());
        if (m == null) {
            return new ForbiddenCheck();
        }
        if (m.getId().equals(req.getMember().getId())) {
            return new ViewMemberCheck(m);
        }
        return new ForbiddenCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String jobid = req.getParameter((Parameter)StandardParameters.jobid);
        PublishJobDetails job = PublishJobs.getJob(jobid);
        if (job == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "There are no jobs with ID " + jobid + ", this may be because the job list has been refreshed from the admin console.");
            return;
        }
        Publisher publisher = new Publisher(Publisher.PublisherAction.CHECK);
        publisher.setProcessID(jobid);
        publisher.run();
        String response = publisher.getResponse();
        XMLWriter xml = res.getXMLWriter();
        xml.writeXML(response);
    }
}

