/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.util.List;
import org.pageseeder.psml.toc.XRefLoopException;

@Requires(database=true, group=true, parameters={"publicationtype"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class ReloadPublicationConfig
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group project = req.getGroup();
        assert (project != null);
        if (!GroupRule.isProject((Group)project)) {
            return new NoCheck();
        }
        return new ConfigureProjectCheck(project);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        PublicationManager manager = PublicationManager.singleton();
        Group project = req.getGroup();
        assert (project != null);
        if (!GroupRule.isProject((Group)project)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Group must be a project");
            return;
        }
        String publicationType = req.getParameter((Parameter)StandardParameters.publicationtype);
        assert (publicationType != null);
        manager.reloadPublicationConfig(project, publicationType);
        List pubs = DatabaseQuery.getPublicationsByProjectType((Database)db, (String)project.getName(), (String)publicationType);
        for (Publication pub : pubs) {
            Group group = DatabaseQuery.getGroupById((Database)req.getDatabase(), (Long)pub.getDefaultGroupId());
            if (group == null || !group.getOwnerDirectory().equals(project.getOwnerDirectory())) continue;
            try {
                manager.getNumberedTOC(db, pub, true);
            }
            catch (XRefLoopException xRefLoopException) {
                // empty catch block
            }
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)pub.getRootURIId());
            List versions = URIRule.getReleasesForURI((Database)req.getDatabase(), (URI)uri, (Publication)pub, (int)1, (int)-1, null);
            for (XLink version : versions) {
                manager.clearCachedTOCVersion(pub, version.getContentTitle());
            }
            manager.clearCachedTOCVersion(pub, "original");
            manager.clearCachedTOC(pub);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("publication-config-reload");
        out.endObject();
    }
}

