/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Group;
import com.pageseeder.psml.GetConfig;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true)
public final class ListPublicationConfigs
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        String includes = req.getParameter((Parameter)StandardParameters.includes, "publication-config");
        List<String> includeFiles = Arrays.asList(includes.split(","));
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("publication-types");
        String ownerdir = group.getOwnerDirectory();
        Set types = PSMLFiles.listAvailableTypes((String)ownerdir, (String)"publication");
        for (String type : types) {
            String folder = "publication" + File.separator + type + File.separator + "publication-config.xml";
            xml.openElement("publication-type");
            xml.attribute("name", type);
            xml.attribute("definedby", String.join((CharSequence)",", PSMLFiles.listDefinedBy((String)ownerdir, (String)folder)));
            if (includeFiles.contains("publication-config")) {
                GetConfig.includeFile(xml, ownerdir, folder, "publication-config.xml");
            }
            xml.closeElement();
        }
        xml.closeElement();
    }
}

