/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddEditXLinksCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.psml.PSML;
import com.pageseeder.psml.PSMLTransformer;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.uri.URIEditLock;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.psml.diff.PSMLDiffer;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(uri=true, group=true, member=true, parameters={"fragment", "transformation"})
public final class TransformFragment
implements Generator,
SingleCheck {
    private static final int DEFAULT_MAX_EVENTS = 4000000;
    private static final Pattern FRAGMENT_LABELS = Pattern.compile("^<[^>]+\\slabels=\"([^\"]*)");

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)(URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new AddEditXLinksCheck(req.getGroup(), req.getURI())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String new_content;
        String transformedContent;
        File xsltScript;
        Database db = req.getDatabase();
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        String transformation = req.getParameter((Parameter)StandardParameters.transformation);
        boolean preview = req.getParameter((Parameter)StandardParameters.preview, false);
        boolean diff = req.getParameter((Parameter)StandardParameters.diffx, false);
        HashMap<String, String> parameters = new HashMap<String, String>();
        req.getParameters().keySet().stream().filter(p -> p.startsWith("parameter.")).forEach(p -> parameters.put(p.substring(10), req.getParameter(p, "")));
        Member author = req.getMember();
        URI uri = req.getURI();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        if (!LocatorRule.isValidFragmentID((String)fragment)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.FRAGMENT_INVALID);
            return;
        }
        if (URIRule.isInvalidFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_CASE_MISMATCH, "A fragment with this ID exists with a different case");
            return;
        }
        if (req.getParameter((Parameter)StandardParameters.reload, false)) {
            PSMLTransformer.clearCache();
        }
        if ((xsltScript = PSMLTransformer.getTransformationScript(group, transformation)) == null || !xsltScript.exists()) {
            res.setError(GeneratorStatus.NOT_FOUND, "Invalid transformation " + transformation);
            return;
        }
        XMLWriter xml = res.getXMLWriter();
        if (diff) {
            String difference;
            try {
                difference = this.transformAndDiff(uri, group, author, db, fragment, xsltScript, parameters);
            }
            catch (Exception ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to perform diff on content: " + ex.getMessage());
                return;
            }
            xml.openElement("fragment-transform");
            xml.attribute("diff", "true");
            xml.writeXML(difference);
            xml.closeElement();
            return;
        }
        PSMLTransformer transformer = new PSMLTransformer(uri, group, author, db);
        try {
            transformedContent = transformer.transformFragment(fragment, xsltScript, parameters);
        }
        catch (PageseederException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
            return;
        }
        if (preview) {
            xml.openElement("fragment-transform");
            xml.attribute("preview", "true");
            xml.writeXML(transformedContent);
            xml.closeElement();
            return;
        }
        URIEditLock lock = URIEditLock.newInstance(uri.getId());
        if (!lock.lock()) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Another edit for this URI is currently being saved.");
            return;
        }
        try {
            Date previousModified = uri.getLastModified();
            FragmentEditor editor = new FragmentEditor(uri, fragment, author, group);
            String notesContent = req.getParameter((Parameter)StandardParameters.note, "");
            if (notesContent.isEmpty()) {
                notesContent = null;
            }
            String notesTitle = req.getParameter((Parameter)StandardParameters.note_title, "Edit note");
            String nLabels = req.getParameter((Parameter)StandardParameters.note_labels, "");
            String[] notesLabels = nLabels.isEmpty() ? null : nLabels.split(",");
            editor.setNotes(notesContent, notesTitle, notesLabels);
            Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)fragment);
            if (PSML.editClash(loc, group, req.getParameter((Parameter)StandardParameters.lastmodified), db, res)) {
                return;
            }
            String labs = req.getParameter((Parameter)StandardParameters.labels);
            Matcher m = FRAGMENT_LABELS.matcher(transformedContent);
            if (labs == null && m.find()) {
                labs = m.group(1);
            }
            if (!URIUtils.checkLabels(res, labs)) {
                return;
            }
            String[] labels = labs == null || labs.isEmpty() ? null : labs.split(",");
            editor.edit(db, transformedContent, "application/vnd.pageseeder.psml+xml", null, labels, !"default".equalsIgnoreCase(fragment));
            FragmentEditor.Status status = editor.getStatus();
            String messages = String.join((CharSequence)"\n", editor.getErrors());
            if (status == FragmentEditor.Status.XREF_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.XREF_PROCESSING_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.VALIDATION_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.VALIDATION_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.NOT_MODIFIED) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, "Not modified: " + messages);
                return;
            }
            if (status == FragmentEditor.Status.UNKNOWN_ERROR) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, messages);
                return;
            }
            uri.setLastModified(new Date());
            req.getTransaction().commitAndStart();
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            resolver.setFragment(fragment);
            resolver.setPSMLFormat(true);
            try (InputStream in = resolver.getContent(db);){
                new_content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            catch (URIException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document's content: " + ex.getMessage());
                lock.unlock();
                return;
            }
            if (new_content == null || new_content.isEmpty()) {
                new_content = "<fragment/>";
            }
            PSML.indexFragmentAndTargetURIs(db, uri, editor, loc, previousModified, "Editing");
        }
        finally {
            lock.unlock();
        }
        xml.openElement("fragment-transform");
        xml.writeXML(new_content);
        xml.closeElement();
    }

    private String transformAndDiff(URI uri, Group group, Member author, Database db, String fragment, File xsltScript, Map<String, String> parameters) throws IOException, URIException, DiffException, PageseederException {
        String currentContent;
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        resolver.setFragment(fragment);
        resolver.setPSMLFormat(true);
        try (InputStream in = resolver.getContent(db);){
            currentContent = Strings.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        PSMLTransformer transformer = new PSMLTransformer(uri, group, author, db);
        String transformedContent = transformer.transformFragmentContent(currentContent, xsltScript, parameters);
        StringWriter diffout = new StringWriter();
        PSMLDiffer differ = new PSMLDiffer(GlobalSettings.getInt((String)"diffXMaxEvents", (int)4000000));
        differ.diff((Reader)new StringReader(transformedContent), (Reader)new StringReader(currentContent), (Writer)diffout);
        return diffout.toString();
    }
}

