/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.diff.OriginTracker;
import com.pageseeder.base.diff.TrackedSequence;
import com.pageseeder.base.diff.TrackerXMLOutput;
import com.pageseeder.base.document.FragmentTracker;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import org.pageseeder.diffx.DiffException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(group=true, uri=true, parameters={"fragment"})
@Output(types={OutputType.XML})
public class TrackFragmentContent
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackFragmentContent.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        long start_editid = req.getParameter((Parameter)StandardParameters.start_editid, -2L);
        long end_editid = req.getParameter((Parameter)StandardParameters.end_editid, -2L);
        if (!URIRule.hasFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
            return;
        }
        if (end_editid > 0L && start_editid > end_editid) {
            res.setError(GeneratorStatus.BAD_REQUEST, "start edit must be before end edit");
            return;
        }
        List edits = new FragmentTracker(req.getURI(), fragment, group, db).loadEdits(start_editid, end_editid);
        try {
            List history = edits.stream().map(FragmentTracker::toTrackedContent).collect(Collectors.toList());
            StringWriter results = new StringWriter();
            if (!history.isEmpty()) {
                OriginTracker tracker = new OriginTracker();
                TrackedSequence result = tracker.track(history, start_editid < 0L);
                TrackerXMLOutput resultsOutput = new TrackerXMLOutput((Writer)results);
                resultsOutput.setReference(FragmentTracker::toOriginReference);
                resultsOutput.setTextFormat(FragmentTracker::toOriginAttributes);
                resultsOutput.write(result);
            }
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("track-changes");
            out.startObject("result");
            out.field("psml", results.toString(), OutputPrinter.FieldOption.XML_COPY);
            out.endObject();
            out.startCollection("edits");
            for (FragmentTracker.Edit edit : edits) {
                edit.print((OutputPrinter)out);
            }
            out.endCollection();
            out.endObject();
            out.close();
        }
        catch (DiffException ex) {
            LOGGER.error("Failed to track fragment changes", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to track fragment changes: " + ex.getMessage());
        }
    }
}

