/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddEditXLinksCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.FragmentIDsLoader;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.psml.PSML;
import com.pageseeder.psml.Structure;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Requires(uri=true, group=true, member=true)
public final class PutStructure
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(PutStructure.class);
    public static final String PSML_STRUCTURE_SCHEMA = "/com/pageseeder/psml/psml-structure.xsd";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddEditXLinksCheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI uri = req.getURI();
        if (!URIRule.isPSML((URI)uri) || uri.getExternal().booleanValue()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "URI must be an internal PSML document");
            return;
        }
        String newStructure = req.getContent();
        try {
            String err = XMLHelpers.validateXmlFileWithSchema((String)newStructure, (String)"ps://com/pageseeder/psml/psml-structure.xsd", null);
            if (!err.isEmpty()) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Structure is invalid: " + err);
                return;
            }
        }
        catch (IOException | SAXException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Failed to validate structure: " + ex.getMessage());
            return;
        }
        Member author = req.getMember();
        Database db = req.getDatabase();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        try {
            XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)group, null);
            if (PSML.structureClash(structure, req.getParameter((Parameter)StandardParameters.lastmodified), res)) {
                return;
            }
            InputStream oldStructure = Structure.getStructureContent(structure, uri, group, db);
            FragmentIDsLoader loader = new FragmentIDsLoader();
            XMLUtils.parse((InputStream)oldStructure, (ContentHandler)loader);
            List oldFragmentIDs = loader.getFragmentIDs();
            FragmentIDsLoader newLoader = new FragmentIDsLoader();
            XMLUtils.parse((InputStream)new ByteArrayInputStream(newStructure.getBytes(StandardCharsets.UTF_8)), (ContentHandler)newLoader);
            List newFragmentIDs = newLoader.getFragmentIDs();
            XLinkRule.createStructureXLink((URI)uri, (Group)group, (Database)db, (String)newStructure, (Member)author, null, (String)"Structure Edit");
            for (String frag : newFragmentIDs) {
                if (oldFragmentIDs.contains(frag)) continue;
                if ("default".equalsIgnoreCase(frag)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "Fragment ID 'default' is invalid");
                    return;
                }
                for (Locator loc : uri.getLocatorsCol((Object)Predicates.predicateLocatorFragment((Database)db, (String)frag))) {
                    String existing = loc.getFragment();
                    if (!frag.equalsIgnoreCase(existing) || frag.equals(existing)) continue;
                    res.setError(GeneratorStatus.BAD_REQUEST, "Cannot change case of existing fragment ID: " + existing);
                    return;
                }
                this.revertFragment(group, uri, frag, author, db);
            }
            for (String frag : oldFragmentIDs) {
                if (newFragmentIDs.contains(frag)) continue;
                this.archiveFragment(group, uri, frag, author, db);
            }
        }
        catch (FoundationException | ProcessException ex) {
            LOGGER.error("Failed to update URI structure", ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to update URI structure: " + ex.getMessage());
            return;
        }
        uri.setLastModified(new Date());
        req.getTransaction().commitAndStart();
        Publications.updateURI((URI)uri);
        ChangesManager.getInstance().modifyURI(db, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
        XMLWriter xml = res.getXMLWriter();
        xml.writeXML(newStructure);
    }

    private void revertFragment(Group group, URI uri, String fragment, Member author, Database db) throws DatabaseException, IOException {
        String contentType;
        XLink edit = DatabaseQuery.getXLinkByURIGroupLastEditFragmentDraftCreationBeforeStatusChangedAfter((Database)db, (URI)uri, (Group)group, (String)fragment, (boolean)true, (boolean)false, (boolean)false, null, null, null);
        Content content = edit != null && edit.getContents().hasNext() ? (Content)edit.getContents().next() : null;
        FragmentEditor editor = new FragmentEditor(uri, fragment, author, group);
        String[] labels = edit != null ? Labels.getLabels((XLink)edit) : new String[]{};
        String fragType = edit != null ? PSMLContentUtils.getFragmentType((XLink)edit) : null;
        String string = contentType = content != null ? content.getType() : "application/vnd.pageseeder.psml+xml";
        editor.edit(db, (String)(!"application/vnd.pageseeder.psml+xml".equals(contentType) ? "<media-fragment>" + (RuleUtils.isXMLMediaType((String)contentType) ? content.getData() : XML.escape((String)content.getData())) + "</media-fragment>" : (content != null ? content.getData() : "<fragment/>")), contentType, fragType, labels, false);
        FragmentEditor.Status status = editor.getStatus();
        if (status != FragmentEditor.Status.OK) {
            StringBuilder msg = new StringBuilder();
            for (String message : editor.getErrors()) {
                msg.append("\n");
                msg.append(message);
            }
            String messages = String.valueOf((Object)status) + (String)(msg.length() > 0 ? ": " + msg.substring(1) : "");
            throw new DatabaseException(messages);
        }
    }

    private void archiveFragment(Group group, URI uri, String fragment, Member author, Database db) throws DatabaseException {
        FragmentEditor editor = new FragmentEditor(uri, fragment, author, group);
        editor.delete(db);
        FragmentEditor.Status status = editor.getStatus();
        if (status != FragmentEditor.Status.OK) {
            StringBuilder msg = new StringBuilder();
            for (String message : editor.getErrors()) {
                msg.append("\n");
                msg.append(message);
            }
            String messages = String.valueOf((Object)status) + (String)(msg.length() > 0 ? ": " + msg.substring(1) : "");
            throw new DatabaseException(messages);
        }
    }
}

