/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddEditXLinksCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.psml.PSML;
import com.pageseeder.uri.URIEditLock;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(uri=true, group=true, member=true, parameters={"fragment"})
public final class PutFragment
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(PutFragment.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)(URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new AddEditXLinksCheck(req.getGroup(), req.getURI())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String messages;
        Database db = req.getDatabase();
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        String content = req.getParameter((Parameter)StandardParameters.content);
        if (content == null) {
            content = req.getContent();
        }
        String contentType = "application/vnd.pageseeder.psml+xml";
        boolean draft = req.getParameter((Parameter)StandardParameters.draft, false);
        Member author = req.getMember();
        URI uri = req.getURI();
        URIEditLock lock = URIEditLock.newInstance(uri.getId());
        if (!lock.lock()) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Another edit for this URI is currently being saved.");
            return;
        }
        String new_content = null;
        try {
            InputStream in;
            Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
            if (!LocatorRule.isValidFragmentID((String)fragment)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.FRAGMENT_INVALID);
                return;
            }
            if (URIRule.isInvalidFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_CASE_MISMATCH, "A fragment with this ID exists with a different case");
                return;
            }
            Date previousModified = uri.getLastModified();
            FragmentEditor editor = new FragmentEditor(uri, fragment, author, group);
            editor.setHTMLTransform(req.getParameter((Parameter)StandardParameters.html, false));
            editor.setDraft(draft);
            String notesContent = req.getParameter((Parameter)StandardParameters.note, "");
            if (notesContent.isEmpty()) {
                notesContent = null;
            }
            String notesTitle = req.getParameter((Parameter)StandardParameters.note_title, "Edit note");
            String nLabels = req.getParameter((Parameter)StandardParameters.note_labels, "");
            String[] notesLabels = nLabels.isEmpty() ? null : nLabels.split(",");
            editor.setNotes(notesContent, notesTitle, notesLabels);
            Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)fragment);
            if (PSML.editClash(loc, group, req.getParameter((Parameter)StandardParameters.lastmodified), db, res)) {
                LOGGER.warn("Edit clash on URI ID: {}, fragment: {}, draft: {}, lastmodified: {}", new Object[]{uri.getId(), fragment, draft, req.getParameter((Parameter)StandardParameters.lastmodified)});
                return;
            }
            String labs = req.getParameter((Parameter)StandardParameters.labels);
            if (!URIUtils.checkLabels(res, labs)) {
                return;
            }
            String[] labels = labs == null ? null : (labs.isEmpty() ? new String[]{} : labs.split(","));
            editor.edit(db, content, contentType, null, labels, !"default".equalsIgnoreCase(fragment));
            FragmentEditor.Status status = editor.getStatus();
            messages = String.join((CharSequence)"\n", editor.getErrors());
            if (status == FragmentEditor.Status.XREF_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.XREF_PROCESSING_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.VALIDATION_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.VALIDATION_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.NOT_MODIFIED) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, "Not modified: " + messages);
                return;
            }
            if (status == FragmentEditor.Status.UNKNOWN_ERROR) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, messages);
                return;
            }
            uri.setLastModified(new Date());
            req.getTransaction().commitAndStart();
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            resolver.setFragment(fragment);
            resolver.setFragmentInfo(true);
            resolver.setPSMLFormat(true);
            if (draft) {
                resolver.includeDraftContent(author.getId());
            }
            if (req.getParameter((Parameter)StandardParameters.transclude, false)) {
                UserDetails userdetails = new UserDetailsManager().get(req.getDatabase(), req.getMember().getId(), false);
                resolver.setTransclude(userdetails);
                String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
                if (publicationid != null) {
                    int position = (int)req.getParameter((Parameter)StandardParameters.position, 1L);
                    Publication publication = Publications.findValidURIPublication((Database)req.getDatabase(), (String)publicationid, (boolean)false, (URI)uri);
                    if (publication != null) {
                        resolver.setPublication(publication, position, null, false);
                    }
                }
            }
            try {
                in = resolver.getContent(req.getDatabase());
            }
            catch (URIException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document's content: " + ex.getMessage());
                lock.unlock();
                return;
            }
            try {
                new_content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            finally {
                in.close();
            }
            new_content = new_content == null || new_content.isEmpty() ? "<document-fragment/>" : new_content.replaceAll("<\\?xml(.*?)\\>", "");
            if (!draft) {
                PSML.indexFragmentAndTargetURIs(db, uri, editor, loc, previousModified, "Editing");
            }
        }
        finally {
            lock.unlock();
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("fragment-creation");
        if (!messages.isEmpty()) {
            xml.attribute("unresolved-xrefs", "true");
        }
        xml.writeXML(new_content);
        xml.closeElement();
    }
}

