/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.util.ValidationErrorHandler;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.xml.Schematron;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.psml.IncomingContentHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.template.DocumentTemplate;
import org.pageseeder.psml.template.TemplateException;
import org.pageseeder.psml.template.TemplateFactory;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.Validator;
import org.pageseeder.schematron.svrl.SVRL;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PSMLConfigValidator {
    private static final String LABEL_CONFIG_SCHEMA = "ps://com/pageseeder/developer/label-config.xsd";
    private static final String DOCUMENT_CONFIG_SCHEMA = "ps://com/pageseeder/developer/document-config.xsd";
    private static final String URL_CONFIG_SCHEMA = "ps://com/pageseeder/developer/url-config.xsd";
    private static final String PUBLICATION_CONFIG_SCHEMA = "ps://com/pageseeder/developer/publication-config.xsd";
    private static final String XREF_CONFIG_SCHEMA = "ps://com/pageseeder/developer/xref-config.xsd";
    private static final String EDITOR_CONFIG_SCHEMA = "ps://com/pageseeder/developer/editor-config.xsd";
    private static final String PUBLISH_CONFIG_SCHEMA = "ps://com/pageseeder/developer/publish-config.xsd";
    private static final String PUBLISH_CONFIG_SCHEMATRON = "/com/pageseeder/developer/publish-config.sch";
    private static final String SCHEDULE_CONFIG_SCHEMA = "ps://com/pageseeder/developer/schedule-config.xsd";
    private static final String SCHEMATRON_SCHEMA = "ps://com/pageseeder/developer/iso-schematron-2016.xsd";
    private static final String MEMBER_DETAILS_SCHEMA = "ps://com/pageseeder/developer/member-details.xsd";
    private static final String PDF_EXPORT_CONFIG_SCHEMA = "ps://org/pageseeder/pdf/schema/pdf-export-config.xsd";
    private static final String WORD_EXPORT_CONFIG_SCHEMA = "ps://org/pageseeder/docx/schema/word-export-config.xsd";
    private static final String WORD_IMPORT_CONFIG_SCHEMA = "ps://org/pageseeder/docx/schema/word-import-config.xsd";
    private static final String PSML_SPLIT_CONFIG_SCHEMA = "ps://org/pageseeder/psml/split/psml-split-config.xsd";
    private static final String DOCUMENT_TEMPLATE_SCHEMATRON = "/com/pageseeder/developer/document-template.sch";
    private static final String MEDIA_TEMPLATE_SCHEMATRON = "/com/pageseeder/developer/media-template.sch";
    private static final String URL_TEMPLATE_SCHEMATRON = "/com/pageseeder/developer/url-template.sch";
    private static final String PSML_SCHEMA = "ps://com/pageseeder/load/psml-portable.xsd";
    private static final String PSML_SCHEMATRON = "/com/pageseeder/load/psml-portable.sch";
    private static final Pattern ENTITIES_MATCHER = Pattern.compile("(<!ENTITY)|(<!DOCTYPE)");
    private static final Pattern UNPARSED_TEXT_MATCHER = Pattern.compile("unparsed-text\\W*\\(");
    private final List<String> errors = new ArrayList<String>();
    private boolean valid = false;
    private @Nullable Validator schematronPSML = null;
    private @Nullable Validator schematronDocumentTemplate = null;
    private @Nullable Validator schematronMediaTemplate = null;
    private @Nullable Validator schematronPublishConfig = null;
    private @Nullable Validator schematronURLTemplate = null;

    public boolean validateConfigFile(File config) {
        String location = config.getAbsolutePath().replace(File.separatorChar, '/');
        try {
            if (location.endsWith("/document-template.psml") || location.endsWith("/media-template.psml") || location.endsWith("/url-template.psml")) {
                this.validateDocumentTemplate(config);
            } else {
                String schema = this.findSchema(location);
                if (schema == null) {
                    return false;
                }
                this.validateConfig(config, schema);
            }
        }
        catch (URIException ex) {
            this.errors.add(ex.getMessage());
        }
        return true;
    }

    public void validateConfigFile(String location, String content) throws URIException {
        if (location.endsWith("/document-template.psml") || location.endsWith("/media-template.psml") || location.endsWith("/url-template.psml")) {
            this.validateDocumentTemplate(content.getBytes(StandardCharsets.UTF_8), location.substring(location.lastIndexOf(47) + 1).toLowerCase());
        } else {
            List<String> errors;
            String schema = this.findSchema(location);
            if (schema != null && (errors = this.validateContent(content, schema)) != null) {
                this.errors.addAll(errors);
            }
            this.validateConfigWithSchematron(location, content.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void validateConfigWithSchematron(String location, byte[] content) throws URIException {
        if (location.endsWith("/publish-config.xml")) {
            this.validateWithSchematron(new ByteArrayInputStream(content), this.getPublishConfigSchematron());
        }
    }

    private void validateDocumentTemplate(File config) throws URIException {
        if (!config.exists() || !config.isFile()) {
            throw new URIException("Config file was not found");
        }
        try (FileInputStream in = new FileInputStream(config);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)baos);
            this.validateDocumentTemplate(baos.toByteArray(), config.getName());
        }
        catch (FileNotFoundException ex) {
            throw new URIException("Config file was not found");
        }
        catch (IOException ex) {
            throw new URIException("Invalid config file was found: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean wasValid() {
        return this.valid;
    }

    private void validateConfig(File config, String schema) throws URIException {
        this.reset();
        if (!config.exists() || !config.isFile()) {
            throw new URIException("Config file was not found");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(config);){
            IOUtils.copy((InputStream)in, (OutputStream)baos);
        }
        catch (FileNotFoundException ex) {
            throw new URIException("Config file was not found");
        }
        catch (IOException ex) {
            throw new URIException("Failed to read config file " + config.getName(), (Throwable)ex);
        }
        List<String> errors = this.validateContent(new String(baos.toByteArray(), StandardCharsets.UTF_8), schema);
        if (!errors.isEmpty()) {
            this.errors.addAll(errors);
        }
        this.validateConfigWithSchematron(config.getPath().replace("\\", "/"), baos.toByteArray());
        this.valid = this.errors.isEmpty();
    }

    public List<String> validateContent(String content, String schema) throws URIException {
        boolean isSchematron = SCHEMATRON_SCHEMA.equals(schema);
        if (ENTITIES_MATCHER.matcher(content).find()) {
            return Collections.singletonList("Doctype declaration and entity declarations are not allowed in this content.");
        }
        try {
            String namespace = isSchematron ? "http://purl.oclc.org/dsdl/schematron" : null;
            SchematronValidator schematronValidator = isSchematron ? new SchematronValidator() : null;
            ValidationErrorHandler eh = XMLHelpers.validateWithSchemaAndHandler((InputSource)new InputSource(new StringReader(content)), (String)schema, (String)namespace, (ContentHandler)schematronValidator);
            List errors = eh.getErrorList();
            if (schematronValidator != null) {
                errors.addAll(schematronValidator.errors);
            }
            return errors;
        }
        catch (SAXException ex) {
            throw new URIException("Invalid config file: " + ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new URIException("Failed to valid config file: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void validateDocumentTemplate(byte[] content, String contName) throws URIException {
        this.reset();
        if (ENTITIES_MATCHER.matcher(new String(content, StandardCharsets.UTF_8)).find()) {
            this.errors.add("Doctype declaration and entity declarations are not allowed in this content.");
            return;
        }
        if ("media-template.psml".equals(contName)) {
            this.validateWithSchematron(new ByteArrayInputStream(content), this.getMediaTemplateSchematron());
        } else if ("url-template.psml".equals(contName)) {
            this.validateWithSchematron(new ByteArrayInputStream(content), this.getURLTemplateSchematron());
        } else {
            this.validateWithSchematron(new ByteArrayInputStream(content), this.getDocumentTemplateSchematron());
        }
        Map<String, String> params = Collections.singletonMap("psparam.fragmentid", "fragment.id");
        TemplateFactory factory = new TemplateFactory(StandardCharsets.UTF_8);
        try {
            DocumentTemplate documentTemplate = (DocumentTemplate)factory.parse(new InputSource(new ByteArrayInputStream(content)));
            StringWriter document = new StringWriter();
            documentTemplate.process(new PrintWriter(document), params);
            this.validatePSML(document.toString(), "document template");
            for (String fragType : documentTemplate.getFragments()) {
                StringWriter fragContent = new StringWriter();
                documentTemplate.getFragmentTemplate(fragType).process(new PrintWriter(fragContent), params);
                String fragContentString = fragContent.toString().replaceAll("\\sname=\"\"\\s", " name=\"x\" ");
                StringWriter newFragContent = new StringWriter();
                IncomingContentHandler handler = new IncomingContentHandler(newFragContent, "fragment-id", fragType);
                try {
                    XMLHelpers.parse((InputStream)new ByteArrayInputStream(fragContentString.getBytes(StandardCharsets.UTF_8)), (ContentHandler)handler);
                }
                catch (FoundationException ex) {
                    throw new URIException("Failed to parse resolved content: " + ex.getMessage(), (Throwable)ex);
                }
                if (handler.wasMediaFragmentStripped()) continue;
                this.validatePSML(newFragContent.toString().trim(), "fragment with type " + fragType);
            }
        }
        catch (IOException | TemplateException ex) {
            throw new URIException("Failed to resolve document template: " + ex.getMessage(), ex);
        }
        this.valid = this.errors.isEmpty();
    }

    private void reset() {
        this.errors.clear();
        this.valid = false;
    }

    private void validatePSML(String content, String contName) throws URIException {
        List<String> xsdErrors = this.validateContent(content, PSML_SCHEMA);
        if (!xsdErrors.isEmpty()) {
            this.errors.add("Invalid " + contName + ":");
            this.errors.addAll(xsdErrors);
        }
        this.validateWithSchematron(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), this.getPSMLSchematron());
    }

    private Validator getPSMLSchematron() throws URIException {
        if (this.schematronPSML == null) {
            try (InputStream schema = PSMLConfigValidator.class.getResourceAsStream(PSML_SCHEMATRON);){
                this.schematronPSML = Schematron.newValidator((Source)new StreamSource(schema));
            }
            catch (IOException | SchematronException ex) {
                throw new URIException("Invalid PSML schematron schema: " + ex.getMessage(), ex);
            }
        }
        return this.schematronPSML;
    }

    private Validator getDocumentTemplateSchematron() throws URIException {
        if (this.schematronDocumentTemplate == null) {
            try (InputStream schStream = PSMLConfigValidator.class.getResourceAsStream(DOCUMENT_TEMPLATE_SCHEMATRON);){
                this.schematronDocumentTemplate = Schematron.newValidator((Source)new StreamSource(schStream));
            }
            catch (IOException | SchematronException ex) {
                throw new URIException("Invalid document template schematron schema: " + ex.getMessage(), ex);
            }
        }
        return this.schematronDocumentTemplate;
    }

    private Validator getMediaTemplateSchematron() throws URIException {
        if (this.schematronMediaTemplate == null) {
            try (InputStream schStream = PSMLConfigValidator.class.getResourceAsStream(MEDIA_TEMPLATE_SCHEMATRON);){
                this.schematronMediaTemplate = Schematron.newValidator((Source)new StreamSource(schStream));
            }
            catch (IOException | SchematronException ex) {
                throw new URIException("Invalid media template schematron schema: " + ex.getMessage(), ex);
            }
        }
        return this.schematronMediaTemplate;
    }

    private Validator getPublishConfigSchematron() throws URIException {
        if (this.schematronPublishConfig == null) {
            try (InputStream schStream = PSMLConfigValidator.class.getResourceAsStream(PUBLISH_CONFIG_SCHEMATRON);){
                this.schematronPublishConfig = Schematron.newValidator((Source)new StreamSource(schStream));
            }
            catch (IOException | SchematronException ex) {
                throw new URIException("Invalid publish config schematron schema: " + ex.getMessage(), ex);
            }
        }
        return this.schematronPublishConfig;
    }

    private Validator getURLTemplateSchematron() throws URIException {
        if (this.schematronURLTemplate == null) {
            try (InputStream schStream = PSMLConfigValidator.class.getResourceAsStream(URL_TEMPLATE_SCHEMATRON);){
                this.schematronURLTemplate = Schematron.newValidator((Source)new StreamSource(schStream));
            }
            catch (IOException | SchematronException ex) {
                throw new URIException("Invalid URL template schematron schema: " + ex.getMessage(), ex);
            }
        }
        return this.schematronURLTemplate;
    }

    private void validateWithSchematron(InputStream content, Validator validator) throws URIException {
        try {
            Map<String, Integer> parameters = Collections.singletonMap("max-xrefs", GlobalSettings.getInt((String)"maxForwardXRefs", (int)3000));
            SchematronResult result = validator.validate((Source)new StreamSource(content), parameters);
            if (result.hasAsserts()) {
                List failedAssertText = SVRL.toMessageList((List)result.toSchematronOutput().getFailedAsserts());
                this.errors.addAll(failedAssertText);
            }
        }
        catch (SchematronException ex) {
            String cause = ex.getCause() != null ? ex.getCause().getMessage() : null;
            throw new URIException("Failed to validate PSML with schematron: " + ex.getMessage() + ": " + cause, (Throwable)ex);
        }
    }

    private @Nullable String findSchema(@Nullable String location) {
        int i;
        int n = i = location == null ? -1 : location.lastIndexOf(47);
        if (i == -1) {
            return null;
        }
        String filename = location.substring(i + 1).toLowerCase();
        String folder = location.substring(0, i).toLowerCase();
        if ("document-config.xml".equals(filename)) {
            return DOCUMENT_CONFIG_SCHEMA;
        }
        if ("url-config.xml".equals(filename)) {
            return URL_CONFIG_SCHEMA;
        }
        if ("xref-config.xml".equals(filename)) {
            return XREF_CONFIG_SCHEMA;
        }
        if ("publication-config.xml".equals(filename)) {
            return PUBLICATION_CONFIG_SCHEMA;
        }
        if ("editor-config.xml".equals(filename)) {
            return EDITOR_CONFIG_SCHEMA;
        }
        if ("word-export-config.xml".equals(filename)) {
            return WORD_EXPORT_CONFIG_SCHEMA;
        }
        if ("pdf-export-config.xml".equals(filename)) {
            return PDF_EXPORT_CONFIG_SCHEMA;
        }
        if ("word-import-config.xml".equals(filename)) {
            return WORD_IMPORT_CONFIG_SCHEMA;
        }
        if ("psml-split-config.xml".equals(filename)) {
            return PSML_SPLIT_CONFIG_SCHEMA;
        }
        if ("label-config.xml".equals(filename)) {
            return LABEL_CONFIG_SCHEMA;
        }
        if ("publish-config.xml".equals(filename)) {
            return PUBLISH_CONFIG_SCHEMA;
        }
        if ("schedule-config.xml".equals(filename)) {
            return SCHEDULE_CONFIG_SCHEMA;
        }
        if ("organization-config.xml".equals(filename)) {
            return "ps://com/pageseeder/base/organization/organization-config.xsd";
        }
        if (filename.endsWith(".sch")) {
            return SCHEMATRON_SCHEMA;
        }
        if (folder.endsWith("/member") && filename.endsWith(".xml")) {
            return MEMBER_DETAILS_SCHEMA;
        }
        return null;
    }

    private static class SchematronValidator
    extends DefaultHandler {
        private final List<String> errors = new ArrayList<String>();

        private SchematronValidator() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String value = attributes.getValue(i);
                if (value == null || !UNPARSED_TEXT_MATCHER.matcher(value).find()) continue;
                this.errors.add("unparsed-text references are not allowed in this content.");
                break;
            }
        }
    }
}

