/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.xml.Schematron;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.uri.URIErrorID;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.Validator;
import org.pageseeder.schematron.svrl.AssertOrReport;

public final class PSML {
    public static final String PSML_SCHEMA_PATH = "/com/pageseeder/load/psml-portable.xsd";
    public static final String PSML_SCHEMATRON_PATH = "/com/pageseeder/load/psml-portable.sch";
    public static final String DEFAULT_EDIT_NOTE_TITLE = "Edit note";
    private static volatile Validator PSML_PORTABLE_VALIDATOR = null;

    private PSML() {
    }

    public static boolean editClash(Locator loc, Group group, @Nullable String lastModified, Database db, GeneratorResponse res) {
        if (lastModified != null) {
            try {
                Date last_date = new Date(ISO8601.DATETIME.parse(lastModified).getTime() + 1000L);
                Iterator thexlfs = loc.getXLinksForLocator((Object)Predicates.predicateXLinkForLocatorByGroupStatusContentRoleLikeDates((Database)db, (Long)group.getId(), (String)"Documentation-Draft", (boolean)false, (String[])new String[]{"Documentation", "Documentation-Hidden"}, null, (Date)last_date));
                if (thexlfs.hasNext()) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EDIT_CLASH);
                    return true;
                }
            }
            catch (ParseException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DATE, "lastmodified date is invalid");
                return true;
            }
        }
        return false;
    }

    public static boolean structureClash(@Nullable XLink structure, @Nullable String lastModified, GeneratorResponse res) {
        if (lastModified != null) {
            try {
                Date last_date = new Date(ISO8601.DATETIME.parse(lastModified).getTime() + 1000L);
                if (structure != null && structure.getDate().after(last_date)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EDIT_CLASH);
                    return true;
                }
            }
            catch (ParseException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DATE, "lastmodified date is invalid");
                return true;
            }
        }
        return false;
    }

    public static String getFileExtension(URI uri) {
        if (URIs.isExternal((URI)uri)) {
            return "";
        }
        String ext = URIRule.getFilename((URI)uri)[1].toLowerCase();
        if (!ext.isEmpty()) {
            ext = ext.substring(1);
        }
        return ext;
    }

    public static void indexFragmentAndTargetURIs(Database db, URI uri, FragmentEditor editor, Locator loc, Date xrefdate, String action) throws QueryFailedException {
        ChangesManager changes = ChangesManager.getInstance();
        ChangesBatch batch = new ChangesBatch(action + " fragment " + loc.getFragment() + " of document " + uri.getDecodedPath());
        changes.startBatch(db, batch);
        changes.modifyURI(db, batch, uri, editor.getURIGroups());
        Publications.updateURI((URI)uri);
        List uris = DatabaseQuery.getURIsByLocatorGroupXRefsCreatedStatusChangedAfter((Database)db, (Locator)loc, (Group)editor.getEditGroups().iterator().next(), (Date)xrefdate, (boolean)true, (boolean)false, (boolean)false, (int)1, (int)-1);
        boolean psml = false;
        for (URI uri2 : uris) {
            if (uri2.getExternal().booleanValue()) {
                if (uri2.getDateCreated().before(xrefdate)) {
                    changes.modifyURI(db, batch, uri2, Collections.emptyList());
                    continue;
                }
                changes.createURI(db, batch, uri2, Collections.emptyList());
                continue;
            }
            changes.modifyURI(db, batch, uri2, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri2.getId()));
            if (!URIRule.isPSML((URI)uri)) continue;
            psml = true;
        }
        if (psml) {
            List puris = DatabaseQuery.getURIsByLocatorGroupXRefsCreatedStatusChangedAfter((Database)db, (Locator)loc, (Group)editor.getEditGroups().iterator().next(), (Date)xrefdate, (boolean)true, (boolean)false, (boolean)true, (int)1, (int)-1);
            for (URI puri : puris) {
                Publications.updateURI((URI)puri);
            }
        }
        List turis = DatabaseQuery.getURIsByLocatorTranscludedAllGroups((Database)db, (Locator)loc);
        for (URI uri2 : turis) {
            changes.modifyURI(db, batch, uri2, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri2.getId()));
        }
        changes.completeBatch(db, batch);
    }

    public static void indexTargetURIs(Database db, Long uriid, Date xrefdate, ChangesBatch batch) throws QueryFailedException {
        ChangesManager changes = ChangesManager.getInstance();
        List uris = DatabaseQuery.getURIsByURIForwardXRefsCreatedStatusChangedAfter((Database)db, (Long)uriid, (Date)xrefdate, null);
        boolean psml = false;
        for (URI uri2 : uris) {
            if (uri2.getExternal().booleanValue()) {
                if (uri2.getDateCreated().before(xrefdate)) {
                    changes.modifyURI(db, batch, uri2, Collections.emptyList());
                    continue;
                }
                changes.createURI(db, batch, uri2, Collections.emptyList());
                continue;
            }
            changes.modifyURI(db, batch, uri2, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri2.getId()));
            if (!URIRule.isPSML((URI)uri2)) continue;
            psml = true;
        }
        if (psml) {
            List puris = DatabaseQuery.getURIsByURIForwardXRefsCreatedStatusChangedAfter((Database)db, (Long)uriid, (Date)xrefdate, (String)"embed");
            for (URI puri : puris) {
                Publications.updateURI((URI)puri);
            }
        }
    }

    public static void indexXRefSourceTargetURIs(Database db, URI uri, String description) throws QueryFailedException {
        ChangesManager changes = ChangesManager.getInstance();
        ChangesBatch batch = new ChangesBatch(description);
        changes.startBatch(db, batch);
        PSML.indexXRefSourceTargetURIsWithBatch(db, uri, batch);
        changes.completeBatch(db, batch);
    }

    public static void indexXRefSourceTargetURIsWithBatch(Database db, URI uri, ChangesBatch batch) throws QueryFailedException {
        ChangesManager changes = ChangesManager.getInstance();
        Collection uris = DatabaseQuery.getURIsByURIXRefsAllGroups((Database)db, (URI)uri, (boolean)false);
        for (URI uri2 : uris) {
            if (!uri2.getExternal().booleanValue()) {
                changes.modifyURI(db, batch, uri2, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri2.getId()));
                continue;
            }
            changes.modifyURI(db, batch, uri2, Collections.emptyList());
        }
    }

    public static @Nullable String validateWithSchematron(Reader psml) throws SchematronException {
        Map<String, Integer> parameters;
        SchematronResult result;
        Objects.requireNonNull(psml, "Cannot validate a null file");
        if (PSML_PORTABLE_VALIDATOR == null) {
            InputStream schematronStream = PSML.class.getResourceAsStream(PSML_SCHEMATRON_PATH);
            InputStreamReader schema = new InputStreamReader(schematronStream, StandardCharsets.UTF_8);
            PSML_PORTABLE_VALIDATOR = Schematron.newValidator((Source)new StreamSource(schema));
        }
        if (!(result = PSML_PORTABLE_VALIDATOR.validate((Source)new StreamSource(psml), parameters = Collections.singletonMap("max-xrefs", GlobalSettings.getInt((String)"maxForwardXRefs", (int)3000)))).isValid()) {
            List failedAsserts = result.toSchematronOutput().getFailedAsserts();
            StringBuilder message = new StringBuilder();
            for (AssertOrReport error : failedAsserts) {
                message.append(error.toMessageString(false)).append('\n');
            }
            return message.toString();
        }
        return null;
    }
}

