/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.util.Date;
import java.util.List;

@Requires(group=true, uri=true, parameters={"fragment"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListFragmentEdits
implements Generator,
SingleCheck,
Cacheable {
    public String getETag(GeneratorRequest req) {
        return String.valueOf(req.getURI().getLastModified().getTime());
    }

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new ViewURICheck(req.getGroup(), req.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String fragment;
        Group group;
        Database db = req.getDatabase();
        URI uri = req.getURI();
        if (!URIRule.hasFragment((URI)uri, (Group)(group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri)), (String)(fragment = req.getParameter((Parameter)StandardParameters.fragment)), (Database)req.getDatabase())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("edits");
        out.startCollection("edits", OutputPrinter.CollectionOption.JSON_ONLY);
        try {
            Date previousDate = null;
            List edits = DatabaseQuery.getXLinksByURIGroupEditsFragment((Database)db, (URI)uri, (Group)group, (String)fragment, (boolean)true);
            for (XLink edit : edits) {
                boolean isDraft = "Documentation-Draft".equals(edit.getStatus());
                out.startObject(isDraft ? "draft" : "edit");
                if (isDraft) {
                    out.field("draft", true, OutputPrinter.FieldOption.JSON_ONLY);
                }
                out.field("id", edit.getId().longValue());
                if (edit.getDate() != null) {
                    Date d = edit.getDate();
                    if (previousDate != null && !previousDate.before(edit.getDate())) {
                        d = new Date(previousDate.getTime() + 1000L);
                    }
                    previousDate = d;
                    out.field("created", ISO8601.format((long)d.getTime(), (ISO8601)ISO8601.DATETIME));
                }
                if ("Documentation-Hidden".equals(edit.getContentRole())) {
                    out.field("deleted", true);
                }
                if ("Documentation-Original".equals(edit.getContentRole()) && edit.equals(edits.get(0))) {
                    out.field("original", true);
                } else {
                    out.writeEditMembers(edit);
                }
                List notes = DatabaseQuery.getRepliesByContentRole((Database)db, (XLink)edit, (String[])new String[]{"Documentation-Note"}, null);
                if (!notes.isEmpty()) {
                    out.startCollection("notes");
                    for (XLink note : notes) {
                        PSMLContentBuilder.note((XLink)note, (OutputPrinter)out);
                    }
                    out.endCollection();
                }
                out.endObject();
            }
        }
        finally {
            out.endCollection();
            out.endObject();
            out.flush();
        }
    }
}

