/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelConfigManager;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Group;
import com.pageseeder.psml.GetConfig;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.SAXException;

@Requires(group=true)
public final class ListConfigs
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, IOException {
        Group group = req.getGroup();
        String template = GroupRule.getTemplate((Group)group);
        String includes = req.getParameter((Parameter)StandardParameters.includes, "document-config,document-template,editor-config");
        List<String> includeFiles = Arrays.asList(includes.split(","));
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("document-types");
        LabelConfig labelConfig = null;
        try {
            labelConfig = LabelConfigManager.getLabelConfig((String)template);
        }
        catch (SAXException ex) {
            throw new GeneratorException("Unable to load project labels", (Throwable)ex);
        }
        Set types = PSMLFiles.listAvailableTypes((String)template, (String)"psml");
        for (String type : types) {
            String folder = "psml" + File.separator + type;
            xml.openElement("document-type");
            xml.attribute("name", type);
            xml.attribute("definedby", String.join((CharSequence)",", PSMLFiles.listDefinedBy((String)template, (String)folder)));
            try {
                String config;
                if (includeFiles.contains("document-config") && (config = PSMLFiles.findDocumentConfig((String)template, (String)type, (LabelConfig)labelConfig, null)) != null) {
                    xml.writeXML(config);
                }
                if (includeFiles.contains("document-template")) {
                    GetConfig.includeFile(xml, template, folder, "document-template.psml");
                }
                if (includeFiles.contains("editor-config")) {
                    GetConfig.includeFile(xml, template, folder, "editor-config.xml");
                }
            }
            catch (FoundationException ex) {
                xml.attribute("error", "Invalid document config file: " + ex.getMessage());
                return;
            }
            xml.closeElement();
        }
        xml.closeElement();
    }
}

