/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.Comments;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@Requires(member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDraftEditsForMember
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 10L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 10L);
        Database db = req.getDatabase();
        Long memberid = req.getMember().getId();
        List drafts = DatabaseQuery.getXLinksByDraftEditMember((Database)db, (int)page, (int)pagesize, (Long)memberid, (boolean)true);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("drafts");
        out.startCollection("drafts", OutputPrinter.CollectionOption.JSON_ONLY);
        if (drafts.size() == pagesize + 1) {
            out.field("limitreached", true);
            drafts.remove(pagesize);
        }
        try {
            Collection<Group> groups = Comments.getReturnGroups(req);
            for (XLink draft : drafts) {
                Locator locator = this.findLocator(draft);
                if (locator == null) continue;
                out.writeDraftEdit(draft, locator, groups, true);
            }
        }
        finally {
            out.endCollection();
            out.endObject();
            out.flush();
        }
    }

    private Locator findLocator(XLink edit) {
        Iterator iterator = XLinks.getThreadRoot((XLink)edit).getLocatorsForXLinkCol().iterator();
        if (iterator.hasNext()) {
            LocatorForXLink lfx = (LocatorForXLink)iterator.next();
            return lfx.getLocator();
        }
        return null;
    }
}

