/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.uri.URIEditLock;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Requires(uri=true, member=true, group=true, parameters={"label", "newcontent"})
public final class EditInlineLabel
implements Generator,
SingleCheck {
    private static final String EMPTY_LABEL = "\u00a0";

    @ContentPermission(value=EditURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup(), req.getURI()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI uri = req.getURI();
        Database db = req.getDatabase();
        if (!URIRule.isPSML((URI)uri)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.UNSUPPORTED_MEDIA_TYPE, "Only PSML documents are supported.");
            return;
        }
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        String newContent = req.getParameter((Parameter)StandardParameters.newcontent, EMPTY_LABEL);
        String oldContent = req.getParameter((Parameter)StandardParameters.oldcontent);
        String labelName = req.getParameter((Parameter)StandardParameters.label);
        if (fragment == null && oldContent == null || labelName == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Missing Parameter: fragment=" + fragment + ", oldcontent=" + oldContent + ", label=" + labelName);
            return;
        }
        URIEditLock lock = URIEditLock.newInstance(req.getURI().getId());
        if (!lock.lock()) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Another edit for this URI is currently being saved.");
            return;
        }
        try {
            String messages;
            InputStream in;
            InlineLabelReplacer replacer;
            Group group;
            block25: {
                group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
                if (fragment != null && !URIRule.hasFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
                    return;
                }
                DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
                if (fragment != null) {
                    resolver.setFragment(fragment);
                }
                replacer = new InlineLabelReplacer(labelName, oldContent, newContent);
                try {
                    in = resolver.getContent(db);
                    if (in.available() != 0) break block25;
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "Fragment was not found with ID " + fragment);
                    return;
                }
                catch (FoundationException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to parse document content: " + ex.getMessage());
                    lock.unlock();
                    return;
                }
            }
            XMLHelpers.parse((InputStream)in, (ContentHandler)replacer);
            fragment = replacer.finalFragmentID;
            if (fragment == null) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "Fragment was not found: fragment=" + fragment + ", oldcontent=" + oldContent + ", label=" + labelName);
                return;
            }
            String fragmentContent = replacer.finalFragmentContent;
            if (fragmentContent == null) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "Failed to build new content");
                return;
            }
            FragmentEditor editor = new FragmentEditor(uri, fragment, req.getMember(), group);
            editor.edit(db, fragmentContent, "application/vnd.pageseeder.psml+xml", replacer.finalFragmentType, null, true);
            FragmentEditor.Status status = editor.getStatus();
            StringBuilder msg = new StringBuilder();
            for (String message : editor.getErrors()) {
                msg.append("\n");
                msg.append(message);
            }
            String string = messages = msg.length() > 0 ? msg.substring(1) : "";
            if (status == FragmentEditor.Status.XREF_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.XREF_PROCESSING_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.VALIDATION_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.VALIDATION_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.UNKNOWN_ERROR) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, messages);
                return;
            }
            uri.setLastModified(new Date());
            req.getTransaction().commitAndStart();
            ChangesManager.getInstance().modifyURI(db, uri, editor.getURIGroups());
        }
        finally {
            lock.unlock();
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("label-modification", true);
        xml.attribute("fragment", fragment);
        xml.attribute("uriid", uri.getId().toString());
        xml.openElement("inline");
        xml.attribute("label", labelName);
        xml.writeText(newContent);
        xml.closeElement();
        xml.closeElement();
    }

    private static class InlineLabelReplacer
    extends DefaultHandler {
        private final String labelName;
        private final String oldLabelContent;
        private final String newLabelContent;
        private String finalFragmentID = null;
        private String finalFragmentType = null;
        private String finalFragmentContent = null;
        private String fragmentID = null;
        private String fragmentType = null;
        private XMLWriter fragmentContent = null;
        private StringBuilder potentialContent = null;

        public InlineLabelReplacer(String name, String oldcontent, String newcontent) {
            this.oldLabelContent = oldcontent;
            this.newLabelContent = newcontent;
            this.labelName = name;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (PSMLContentUtils.isFragmentElement((String)localName)) {
                if (this.finalFragmentID == null) {
                    this.fragmentContent = new XMLStringWriter(XML.NamespaceAware.No);
                    this.fragmentID = attributes.getValue("id");
                    this.fragmentType = attributes.getValue("type");
                }
            } else if (this.fragmentID != null && "inline".equals(localName) && this.labelName.equals(attributes.getValue("label"))) {
                this.potentialContent = new StringBuilder();
            }
            if (this.fragmentContent != null) {
                try {
                    this.fragmentContent.openElement(localName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.fragmentContent.attribute(attributes.getLocalName(i), attributes.getValue(i));
                    }
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to open element " + localName);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String addText = null;
            if (this.fragmentID != null && "inline".equals(localName) && this.potentialContent != null) {
                String value = this.potentialContent.toString();
                if (value.equals(this.oldLabelContent) || this.oldLabelContent == null) {
                    this.finalFragmentID = this.fragmentID;
                    this.finalFragmentType = this.fragmentType;
                    addText = this.newLabelContent;
                } else {
                    addText = value;
                }
                this.potentialContent = null;
            }
            if (this.fragmentContent != null) {
                try {
                    if (addText != null) {
                        this.fragmentContent.writeText(addText);
                    }
                    this.fragmentContent.closeElement();
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to close element " + localName);
                }
            }
            if (PSMLContentUtils.isFragmentElement((String)localName)) {
                if (this.fragmentContent != null && this.finalFragmentID != null) {
                    this.finalFragmentContent = this.fragmentContent.toString();
                }
                this.fragmentContent = null;
                this.fragmentID = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.potentialContent != null) {
                this.potentialContent.append(ch, start, length);
            } else if (this.fragmentContent != null) {
                try {
                    this.fragmentContent.writeText(ch, start, length);
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to write text");
                }
            }
        }
    }
}

