/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.PSMLContentUtils;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DocumentTemplateHandler
extends DefaultHandler {
    private static final String TEMPLATE_URI = "http://pageseeder.com/psml/template";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private final XMLWriter xml;
    private CharArrayWriter xmlbuffer = new CharArrayWriter();
    private String propertyxml = "";
    private final String fragElement;
    private final String fragType;
    private final List<String> propertyNames = new ArrayList<String>();
    private final boolean includeValues;
    private boolean inTemplateFragment = false;

    public DocumentTemplateHandler(String element, String type, List<String> propertyNames, boolean includeValues) {
        this.fragElement = element;
        this.fragType = type;
        if (propertyNames != null) {
            this.propertyNames.addAll(propertyNames);
        }
        this.xml = new XMLWriterImpl((Writer)this.xmlbuffer);
        this.includeValues = includeValues;
    }

    public String getPropertyXML() {
        return this.propertyxml;
    }

    @Override
    public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
        boolean isFragment;
        boolean bl = isFragment = PSMLContentUtils.isFragmentElement((String)lName) || PROPERTIES_ELEMENT.equals(lName);
        if (isFragment && (lName.equals(this.fragElement) || TEMPLATE_URI.equals(uri)) && (PROPERTIES_ELEMENT.equals(lName) || this.fragType != null && this.fragType.equals(atts.getValue(TYPE_ATTRIBUTE)))) {
            this.inTemplateFragment = true;
            this.xmlbuffer.reset();
        }
        String pname = atts.getValue(NAME_ATTRIBUTE);
        if (this.inTemplateFragment && PROPERTY_ELEMENT.equals(lName) && !this.propertyNames.contains(pname) && pname != null && !pname.contains("{$")) {
            try {
                this.xml.openElement(lName);
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (!this.includeValues && VALUE_ATTRIBUTE.equals(atts.getLocalName(i))) continue;
                    this.xml.attribute(atts.getLocalName(i), atts.getValue(i));
                }
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + lName, ex);
            }
        }
    }

    @Override
    public void endElement(String uri, String lName, String qName) throws SAXException {
        if (this.inTemplateFragment && (PSMLContentUtils.isFragmentElement((String)lName) || PROPERTIES_ELEMENT.equals(lName))) {
            this.propertyxml = this.xmlbuffer.toString();
            this.inTemplateFragment = false;
            this.xmlbuffer.reset();
        }
    }
}

