/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddEditXLinksCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.psml.PSML;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

@Requires(uri=true, group=true, member=true)
public final class CreateEditNote
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)(URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new AddEditXLinksCheck(req.getGroup(), req.getURI())));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String[] notesLabels;
        String notesContent;
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        Member member = req.getMember();
        Locator loc = null;
        XLink edit = null;
        Long editid = req.getParameter((Parameter)StandardParameters.editid, -1L);
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        if (editid == -1L && fragment == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "An editid or fragment is required");
            return;
        }
        if (editid != -1L) {
            edit = DatabaseQuery.getXLinkById((Database)db, (Long)editid);
            if (edit == null || !"Documentation".equals(edit.getContentRole()) && !"Documentation-Hidden".equals(edit.getContentRole())) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.EDIT_NOT_FOUND, "Edit was not found with ID: " + editid);
                return;
            }
            loc = LocatorRule.getLocatorByXLink((Database)db, (XLink)edit);
            if (!uri.equals((Object)URIRule.getURIByLocator((Database)db, (Locator)loc))) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.EDIT_NOT_FOUND, "Edit with this ID not found on URI: " + editid);
                return;
            }
        } else {
            if (!LocatorRule.isValidFragmentID((String)fragment)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.FRAGMENT_INVALID, "The fragment " + fragment + " is invalid.");
                return;
            }
            if (URIRule.isInvalidFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_CASE_MISMATCH, "A fragment with this ID exists with a different case");
                return;
            }
            loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)fragment);
            if (PSML.editClash(loc, group, req.getParameter((Parameter)StandardParameters.lastmodified), db, res)) {
                return;
            }
            FragmentEditor editor = new FragmentEditor(uri, fragment, member, group);
            try {
                edit = editor.ensureOriginalEdit(uri.getDateCreated(), db);
                if (edit == null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "Fragment has no original content");
                    return;
                }
            }
            catch (FoundationException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load fragment's original content: " + ex.getMessage());
                return;
            }
        }
        if ((notesContent = req.getParameter((Parameter)StandardParameters.content, "")).isEmpty()) {
            notesContent = null;
        }
        String notesTitle = req.getParameter((Parameter)StandardParameters.title, "Edit note");
        String nLabels = req.getParameter((Parameter)StandardParameters.labels, "");
        String[] stringArray = notesLabels = nLabels.isEmpty() ? null : nLabels.split(",");
        if (!URIUtils.checkLabels(res, nLabels)) {
            return;
        }
        XLink note = XLink.create((Database)db);
        note.setContentRole("Documentation-Note");
        note.setContentTitle(notesTitle);
        note.setAccepted(Boolean.valueOf(true));
        note.setModeratorOnly(Boolean.valueOf(false));
        note.setMember(member);
        note.setDate(new Date());
        Labels.setLabels((XLink)note, (String[])notesLabels);
        Collection grps = GroupRule.getEditGroups((Database)db, (Group)group, (URI)uri);
        XLinkRule.addGroups((Database)db, (XLink)note, (Collection)grps);
        Content cont = Content.create((Database)db);
        cont.setType("text/plain");
        if (notesContent != null) {
            cont.setData(notesContent);
        }
        note.addContents(cont);
        note = note.insert(db);
        edit.addReplies(note);
        uri.setLastModified(new Date());
        Set groups = uri.getExternal() != false ? DatabaseQuery.getGroupsByURIReverseXRefsComments((Database)db, (Long)uri.getId()) : Collections.singleton(URIRule.getDefaultGroupForURINonNull((URI)uri));
        for (Group g : groups) {
            List versions = URIRule.getReleasesForURI((Database)db, (URI)uri);
            for (XLink version : versions) {
                if (version.getDate().before(edit.getDate())) continue;
                new DocumentContentResolver(uri.getId(), g.getName(), g.getId()).clearCacheDocument(version.getId());
            }
        }
        req.getTransaction().commitAndStart();
        ChangesManager.getInstance().modifyURI(db, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("note-creation");
        PSMLContentBuilder.note((XLink)note, (OutputPrinter)out);
        out.endObject();
        out.flush();
    }
}

