/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.organization;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.UIConfig;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;

@Output(types={OutputType.XML, OutputType.JSON})
public class GetUIConfig
implements Generator {
    @ContentPermission(value=NoCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        OrganizationManager orgManager = OrganizationManager.instance();
        if (req.getParameter((Parameter)StandardParameters.reload, false) && (orgManager = orgManager.load()).hasError()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Error loading organization config, see general logs for details.");
            return;
        }
        UIConfig config = orgManager.getUIConfig();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("ui");
        out.startObject("style");
        out.field("theme", config.getTheme().toString());
        out.endObject();
        out.startObject("images");
        out.optionalField("logo-filename", config.getLogo());
        out.optionalField("icon-filename", config.getIcon());
        out.endObject();
        out.startCollection("legal");
        for (UIConfig.LegalDocument doc : config.getLegalDocuments()) {
            out.startObject("document");
            out.optionalField("name", doc.getName());
            out.optionalField("title", doc.getTitle());
            out.optionalField("agree-on", doc.getAgreeOn());
            out.endObject();
        }
        out.endCollection();
        if (config.getAccountHomeXML() != null) {
            out.field("account-home", config.getAccountHomeXML(), OutputPrinter.FieldOption.XML_COPY);
        }
        out.endObject();
    }
}

