/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.organization;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;

@Output(types={OutputType.XML, OutputType.JSON})
public class GetSecurityConfig
implements Generator {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        OrganizationManager orgManager = OrganizationManager.instance();
        if (req.getParameter((Parameter)StandardParameters.reload, false) && (orgManager = orgManager.load()).hasError()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Error loading organization config, see general logs for details.");
            return;
        }
        SecurityConfig config = orgManager.getSecurityConfig();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("security");
        out.startObject("login");
        if (!config.getLoginGroups().isEmpty()) {
            out.field("groups", String.join((CharSequence)",", config.getLoginGroups()));
        }
        if (!config.getLoginProjects().isEmpty()) {
            out.field("projects", String.join((CharSequence)",", config.getLoginProjects()));
        }
        out.endObject();
        out.startCollection("tokens", OutputPrinter.CollectionOption.JSON_ONLY);
        Map tokens = config.getTokenExpirations();
        for (Map.Entry entry : tokens.entrySet()) {
            out.startObject("token");
            out.field("type", ((SecurityConfig.TokenType)entry.getKey()).toString());
            out.field("expiration", ((Duration)entry.getValue()).toString());
            out.endObject();
        }
        out.endCollection();
        out.startCollection("members");
        List domains = config.getEmailDomains();
        for (String domain : domains) {
            out.startObject("email");
            out.field("domain", domain);
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }
}

