/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.organization;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.organization.EmailConfig;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true)
public class GetEmailConfig
implements Generator {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        OrganizationManager orgManager = OrganizationManager.instance();
        if (req.getParameter((Parameter)StandardParameters.reload, false) && (orgManager = orgManager.load()).hasError()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Error loading organization config, see general logs for details.");
            return;
        }
        Group group = req.getGroup();
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        String project = group.getOwnerDirectory();
        EmailConfig config = orgManager.getEmailConfig(project);
        if (config == null && globalTemplate != null) {
            project = globalTemplate;
            config = orgManager.getEmailConfig(project);
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("email", true);
        xml.attribute("project", project);
        if (config != null) {
            String emailDomain;
            String dkimDomain = config.getDKIMDomain();
            String dkimSelector = config.getDKIMSelector();
            Boolean dkimDisabled = config.getDKIMDisabled();
            if (dkimDomain != null || dkimSelector != null || dkimDisabled != null) {
                xml.openElement("dkim", true);
                if (dkimDomain != null) {
                    xml.attribute("domain", dkimDomain);
                }
                if (dkimSelector != null) {
                    xml.attribute("selector", dkimSelector);
                }
                if (dkimDisabled != null) {
                    xml.attribute("disabled", dkimDisabled.toString());
                }
                xml.closeElement();
            }
            if ((emailDomain = config.getEmailDomain()) != null) {
                xml.openElement("emails", true);
                xml.attribute("domain", emailDomain);
                xml.closeElement();
            }
            xml.writeXML(config.getNotificationXML());
        }
        SecurityConfig securityConfig = orgManager.getSecurityConfig();
        Map tokens = securityConfig.getTokenExpirations();
        for (Map.Entry entry : tokens.entrySet()) {
            xml.openElement("token", false);
            xml.attribute("type", ((SecurityConfig.TokenType)entry.getKey()).toString());
            xml.attribute("expiration", ((Duration)entry.getValue()).toString());
            xml.closeElement();
        }
        xml.closeElement();
    }
}

