/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.util.Flags;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import com.pageseeder.membership.Memberships;
import java.io.IOException;
import java.util.List;

@Requires(database=true, member=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class ManageMembership
implements Generator,
SingleCheck {
    @ContentPermission(value=EditGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getParameter((Parameter)StandardParameters.force_register, false)) {
            return new ManageAccountCheck();
        }
        return new EditGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Role r;
        Notification notification;
        Member member = Members.getMember(req);
        if (member == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        Database db = req.getDatabase();
        Group group = req.getGroup();
        assert (member != null && group != null);
        String role = req.getParameter((Parameter)StandardParameters.role);
        String listed = req.getParameter((Parameter)StandardParameters.listed);
        String notify = req.getParameter((Parameter)StandardParameters.notification);
        boolean register = req.getParameter((Parameter)StandardParameters.register, false);
        boolean forceRegister = req.getParameter((Parameter)StandardParameters.force_register, false);
        boolean deregister = req.getParameter((Parameter)StandardParameters.deregister, false);
        boolean welcomeEmail = req.getParameter((Parameter)StandardParameters.welcome_email, true);
        if ("admin".equals(group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.GROUP_NOT_ALLOWED);
            return;
        }
        MemberForGroup mfg = Memberships.getMemberForGroup(member, group);
        if (mfg == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NOT_A_MEMBER, "User '" + member.getUsername() + "' is not a member of " + group.getName());
            return;
        }
        if (deregister) {
            if (register || forceRegister) {
                String message = "User '" + member.getUsername() + "' cannot simultaneously register and deregister";
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.CONTRADICTORY_DEREGISTRATION, message);
                return;
            }
            if (role != null) {
                String message = "User '" + member.getUsername() + "' cannot simultaneously be given a role and deregister";
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.CONTRADICTORY_DEREGISTRATION, message);
                return;
            }
        }
        if (!Memberships.checkRole(role, res)) {
            return;
        }
        MemberDetailsConfig config = null;
        if (group.getDetailsForm() != null) {
            try {
                config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
            }
            catch (FoundationException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_CONFIGURE_MEMBER_DETAILS);
                return;
            }
        }
        String flags = mfg.getEditorFlags();
        if (deregister && (flags == null || flags.indexOf(100) == -1)) {
            if (mfg.getModerator() != null) {
                Memberships.removeAsModerator(mfg, db);
            }
            mfg.setEditor(Boolean.FALSE);
            mfg.setEditorFlags("d");
            new UserDetailsManager().remove(member.getId());
        }
        boolean welcomeEmailFailed = false;
        if (forceRegister || register && (flags == null || flags.indexOf(110) == -1 || !GroupRule.acceptInvitationRequired((Database)db, (Group)group))) {
            mfg.setEditorFlags(Flags.remove((String)Flags.remove((String)Flags.remove((String)Flags.remove((String)flags, (char)'d'), (char)'n'), (char)'s'), (char)'m'));
            new UserDetailsManager().remove(member.getId());
            if (welcomeEmail) {
                try {
                    Member m = req.getAuthenticatedMember();
                    Emails.sendMembershipComplete((Database)db, (MemberForGroup)mfg, (Member)m, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
                catch (EmailException ex) {
                    welcomeEmailFailed = true;
                    req.getLogger((Object)this).error("Failed to send new membership email", (Throwable)ex);
                }
            }
        }
        if ((notification = Notification.forType((String)notify)) != null) {
            mfg.setNotification(notification.type());
        }
        if (listed != null) {
            mfg.setListed(Boolean.valueOf("true".equals(listed)));
        }
        if ((r = Role.forAttribute((String)role)) == null) {
            r = Role.forTitle((String)role);
        }
        if (r == null && register) {
            r = Boolean.valueOf(group.getFlags() != null && group.getFlags().contains("t")) != false ? Role.CONTRIBUTOR : Role.REVIEWER;
        }
        if (r != null) {
            if (r == Role.MODERATOR || r == Role.MODERATOR_AND_APPROVER) {
                MemberForGroup moderator = Memberships.findModerator(group, db);
                if (moderator != null && !moderator.getId().equals(mfg.getId())) {
                    Memberships.removeAsModerator(moderator, db);
                }
                if (mfg.getModerator() == null) {
                    Memberships.setAsModerator(mfg, db);
                }
            } else if (mfg.getModerator() != null) {
                Memberships.removeAsModerator(mfg, db);
            }
            String editorFlags = r.updateFlags(mfg.getEditorFlags());
            mfg.setEditorFlags(editorFlags);
            mfg.setEditor(Boolean.valueOf(r.isEditor()));
            new UserDetailsManager().remove(member.getId());
        }
        if (config != null) {
            List fields = MemberGroupDetailsRule.toFieldValues((GeneratorRequest)req);
            MemberGroupDetails mgd = MemberGroupDetailsRule.updateDetails((Database)db, (Member)member, (List)fields, (Group)group, (MemberForGroup)mfg, (boolean)true);
            mfg.setMemberGroupDetails(mgd);
        }
        req.getTransaction().commit();
        ChangesManager.getInstance().modifyMembership(db, mfg);
        new MembershipCache().remove(member.getId());
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("membership-modification");
        if (welcomeEmailFailed) {
            out.field("welcome-email-failed", true);
        }
        out.writeMembership(new Membership(mfg), config, MemberDetailsConfig.Visibility.MANAGER, db);
        out.endObject();
        out.flush();
    }
}

