/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.RegisterForGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.util.Flags;
import com.pageseeder.member.MemberErrorID;
import java.io.IOException;
import java.util.List;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class InviteSelf
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new RegisterForGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        MemberForGroup mfg;
        Notification notify;
        MemberForGroup modmfg;
        boolean moderated;
        String notification = req.getParameter((Parameter)StandardParameters.notification);
        boolean listed = req.getParameter((Parameter)StandardParameters.listed, false);
        boolean sendWelcomeEmail = req.getParameter((Parameter)StandardParameters.welcome_email, true);
        Group group = req.getGroup();
        assert (group != null);
        if ("admin".equals(group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.GROUP_NOT_ALLOWED);
            return;
        }
        if (GroupRule.isPersonalGroup((String)group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NOT_IN_PERSONAL_GROUP);
            return;
        }
        Database db = req.getDatabase();
        boolean confirmed = group.getFlags() != null && group.getFlags().contains("c");
        boolean bl = moderated = group.getFlags() != null && group.getFlags().contains("r");
        if (moderated && ((modmfg = DatabaseQuery.getModeratorByGroupId((Database)db, (Long)group.getId())) == null || !MemberRule.hasEmail((Member)modmfg.getMember()))) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MODERATOR_EMAIL);
            return;
        }
        Member mem = req.getAuthenticatedMember();
        if (mem == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NOT_LOGGED_IN);
            return;
        }
        MemberDetailsConfig config = null;
        if (group.getDetailsForm() != null) {
            try {
                config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
            }
            catch (FoundationException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_CONFIGURE_MEMBER_DETAILS);
                return;
            }
        }
        Role psrole = Role.REVIEWER;
        if (group.hasFlag('t')) {
            psrole = Role.CONTRIBUTOR;
        }
        if ((notify = Notification.forType((String)notification)) == null) {
            String flags = group.getFlags();
            notify = Notification.forFlags((String)flags);
        }
        if ((mfg = DatabaseQuery.getMemberForGroupByGroupIdMemberId((Database)db, (Long)group.getId(), (Long)mem.getId())) != null) {
            if (!MemberForGroupRule.isDeletedMember((MemberForGroup)mfg)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_ALREADY_IN_GROUP);
                return;
            }
        } else {
            mfg = MemberForGroup.create((Database)db);
        }
        mfg.setNotification(notify.type());
        mfg.setListed(Boolean.valueOf(listed));
        mfg.setMember(mem);
        mfg.setEditorFlags(psrole.getFlags());
        mfg.setEditor(Boolean.valueOf(psrole.isEditor()));
        group.addMembersForGroup(mfg);
        MemberGroupDetails mgd = null;
        if (config != null) {
            List details = MemberGroupDetailsRule.toFieldValues((GeneratorRequest)req);
            mgd = MemberGroupDetailsRule.updateDetails((Database)db, (Member)mem, (List)details, (Group)group, (MemberForGroup)mfg, (boolean)true);
            mfg.setMemberGroupDetails(mgd);
        }
        if (confirmed) {
            mfg.setEditorFlags(Flags.add((String)Flags.add((String)mfg.getEditorFlags(), (char)'d'), (char)'s'));
        } else if (moderated) {
            mfg.setEditorFlags(Flags.add((String)Flags.add((String)mfg.getEditorFlags(), (char)'d'), (char)'m'));
        } else {
            new UserDetailsManager().remove(mem.getId());
        }
        mfg.insert(db);
        boolean confirmEmailFailed = false;
        boolean moderatorEmailFailed = false;
        boolean welcomeEmailFailed = false;
        if (confirmed) {
            try {
                Emails.sendMembershipConfirm((Database)db, (MemberForGroup)mfg, null, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            }
            catch (EmailException ex) {
                confirmEmailFailed = true;
                req.getLogger((Object)this).error("Failed to send group confirm email", (Throwable)ex);
            }
        } else if (moderated) {
            try {
                Emails.sendMembershipAccept((Database)db, (MemberForGroup)mfg, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            }
            catch (EmailException ex) {
                moderatorEmailFailed = true;
                req.getLogger((Object)this).error("Failed to send group confirm email", (Throwable)ex);
            }
        } else if (sendWelcomeEmail) {
            try {
                Emails.sendMembershipComplete((Database)db, (MemberForGroup)mfg, null, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            }
            catch (EmailException ex) {
                welcomeEmailFailed = true;
                req.getLogger((Object)this).error("Failed to send group welcome email", (Throwable)ex);
            }
        }
        req.getTransaction().commit();
        ChangesManager.getInstance().createMembership(db, mfg);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("membership-creation");
        if (confirmEmailFailed) {
            out.field("confirm-email-failed", true);
        }
        if (moderatorEmailFailed) {
            out.field("moderator-email-failed", true);
        }
        if (welcomeEmailFailed) {
            out.field("welcome-email-failed", true);
        }
        out.writeMembership(new Membership(mfg), config, MemberDetailsConfig.Visibility.MEMBER, db);
        out.endObject();
        out.flush();
    }
}

