/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberForGroupStatus;
import com.pageseeder.db.model.Role;
import com.pageseeder.member.MemberErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class FindGroupMembers
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;

    @ContentPermission(value=ViewMembersCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("manager".equals(req.getParameter((Parameter)StandardParameters.role))) {
            return new EditGroupCheck(req.getGroup());
        }
        return new ViewMembersCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Group group = req.getGroup();
        HashMap<String, String> fields = new HashMap<String, String>();
        for (String param : req.getParameters().keySet()) {
            String value;
            if (!param.matches("field\\d\\d?") || (value = req.getParameter(param)) == null) continue;
            fields.put(param, req.getParameter(param));
        }
        MemberDetailsConfig config = null;
        if (group.getDetailsForm() != null) {
            try {
                config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
            }
            catch (FoundationException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_CONFIGURE_MEMBER_DETAILS);
                return;
            }
        }
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        boolean subgroups = req.getParameter((Parameter)StandardParameters.subgroups, true);
        String prefix = req.getParameter((Parameter)StandardParameters.prefix);
        String username = req.getParameter((Parameter)StandardParameters.member_username);
        String firstname = req.getParameter((Parameter)StandardParameters.firstname);
        String surname = req.getParameter((Parameter)StandardParameters.surname);
        String email = req.getParameter((Parameter)StandardParameters.email);
        Role role = Role.forAttribute((String)req.getParameter((Parameter)StandardParameters.member_role));
        String status = req.getParameter((Parameter)StandardParameters.status);
        boolean countOnly = req.getParameter((Parameter)StandardParameters.countonly, false);
        ArrayList<MemberForGroupStatus> mfgstatuses = new ArrayList<MemberForGroupStatus>();
        if (status != null) {
            for (String s : status.split(",")) {
                MemberForGroupStatus mfgstatus = MemberForGroupStatus.forName((String)s);
                if (mfgstatus == MemberForGroupStatus.UNKNOWN) continue;
                mfgstatuses.add(mfgstatus);
            }
        }
        Long count = null;
        boolean limitReached = false;
        List memberships = null;
        Collection gfgs = group.getMemberGroups();
        if (countOnly) {
            count = DatabaseQuery.getMemberForGroupByGroupIDDetailsSubgroupsCount((Database)db, (Long)group.getId(), (String)prefix, (String)username, (String)firstname, (String)surname, (String)email, (Role)role, mfgstatuses, fields, (subgroups && !gfgs.isEmpty() ? 1 : 0) != 0);
        } else {
            List mfgs = DatabaseQuery.getMemberForGroupByGroupIDDetailsSubgroups((Database)db, (Long)group.getId(), (String)prefix, (String)username, (String)firstname, (String)surname, (String)email, (Role)role, mfgstatuses, fields, (subgroups && !gfgs.isEmpty() ? 1 : 0) != 0, (int)(subgroups ? 1 : page), (int)pagesize);
            if (mfgs.size() > pagesize && mfgs.size() > 0) {
                if (subgroups && !gfgs.isEmpty()) {
                    Long lastmemberid = ((MemberForGroup)mfgs.get(mfgs.size() - 1)).getMember().getId();
                    for (int i = mfgs.size() - 1; i >= 0 && lastmemberid.equals(((MemberForGroup)mfgs.get(i)).getMember().getId()); --i) {
                        mfgs.remove(i);
                    }
                } else {
                    mfgs.remove(mfgs.size() - 1);
                }
                limitReached = true;
            }
            memberships = MemberForGroupRule.getGroupMemberships((Collection)gfgs, (Collection)mfgs);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("memberships");
        out.field("count", count != null ? count : (long)memberships.size());
        if (limitReached) {
            out.field("limitreached", true);
        }
        out.writeGroup(group);
        if (!countOnly) {
            MemberDetailsConfig.Visibility visibility = "manager".equals(req.getParameter((Parameter)StandardParameters.role)) ? MemberDetailsConfig.Visibility.MANAGER : MemberDetailsConfig.Visibility.GROUP;
            memberships.sort(MemberForGroupRule.SORT_MEMBERSHIP_BY_MEMBER_NAME);
            out.startCollection("memberships", OutputPrinter.CollectionOption.JSON_ONLY);
            for (Membership m : memberships) {
                out.writeMembership(m, UniversalPrinter.MembershipFormatOption.MEMBER_ONLY, config, visibility, db);
            }
            out.endCollection();
        }
        out.endObject();
        out.flush();
    }
}

