/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.member.MemberErrorID;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, member=true, parameters={"mfgid"})
@PublicAPI
public final class DeclineInvitation
implements Generator,
SingleCheck {
    @ContentPermission(value=AuthenticatedInternalCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        if (req.getMember() == null) {
            return new ForbiddenCheck();
        }
        long id = req.getParameter((Parameter)StandardParameters.mfgid, -1L);
        if (id < -1L) {
            return new NoCheck();
        }
        MemberForGroup mfg = DatabaseQuery.getMemberForGroupById((Database)req.getDatabase(), (Long)id);
        if (mfg == null) {
            return new NoCheck();
        }
        Member member = mfg.getMember();
        if (!member.getId().equals(req.getMember().getId())) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(mfg.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        long id = req.getParameter((Parameter)StandardParameters.mfgid, -1L);
        if (id < -1L) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_MEMBERSHIP_ID);
            return;
        }
        MemberForGroup mfg = DatabaseQuery.getMemberForGroupById((Database)req.getDatabase(), (Long)id);
        if (mfg == null) {
            String message = "Invalid Parameter: no MemberForGroup found with ID " + id;
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_MEMBERSHIP_ID, message);
            return;
        }
        if (mfg.getEditorFlags() == null || mfg.getEditorFlags().indexOf(110) == -1) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_ALREADY_ACCEPTED);
            return;
        }
        Group group = mfg.getGroup();
        Long mfgid = mfg.getId();
        mfg.setGroup(null);
        mfg.delete(db);
        req.getTransaction().commit();
        ChangesManager.getInstance().deleteMembership(db, mfgid, group);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("invitation", true);
        xml.element("status", "declined");
        xml.closeElement();
    }
}

