/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mfa.MFA;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import java.io.IOException;

@Requires(database=true, parameters={"challenge", "authenticator"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class VerifyAuthenticator
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        String challengeResponse;
        Member member = req.getAuthenticatedMember();
        Database db = req.getDatabase();
        String challengeId = req.getParameter("challenge");
        String authId = req.getParameter((Parameter)StandardParameters.authenticator);
        assert (authId != null && member != null);
        Authenticator authenticator = Authenticators.getAuthenticator((Database)db, (long)member.getId(), (String)authId);
        if (authenticator == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "No matching authenticator to verify");
            return;
        }
        String code = req.getParameter((Parameter)StandardParameters.code);
        String string = challengeResponse = code != null ? code : req.getParameter("credential");
        if (challengeResponse == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "No challenge response to verify");
            return;
        }
        assert (challengeId != null);
        ChallengeResult result = MFA.verify((Database)db, (Authenticator)authenticator, (String)challengeId, (String)challengeResponse);
        if (result == ChallengeResult.SUCCESS && !authenticator.isVerified()) {
            authenticator.setVerified(true);
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Verified authenticator {}", (Object[])new Object[]{authenticator});
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("authenticator-verification");
        out.field("authenticator", authenticator.getPublicId());
        out.field("verified", result == ChallengeResult.SUCCESS);
        out.field("status", result.id());
        out.endObject();
        out.flush();
    }
}

