/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import javax.servlet.http.HttpSession;

@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class ResetSession
implements Generator,
SingleCheck {
    @ContentPermission(value=AuthenticatedInternalCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Member self = req.getAuthenticatedMember();
        assert (self != null);
        UserDetailsManager userManager = new UserDetailsManager();
        userManager.remove(self.getId());
        String displayArchived = req.getParameter((Parameter)StandardParameters.displayarchived);
        if (displayArchived != null) {
            SecurityUtils.setArchivedGroups((boolean)"true".equals(displayArchived), (HttpSession)req.getHttpServletRequest().getSession());
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("reset-session");
        out.endObject();
        out.flush();
    }
}

