/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.utils.CSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Members {
    private static final Logger LOGGER = LoggerFactory.getLogger(Members.class);
    protected static final int NUMBER_OF_DETAIL_FIELDS = 15;
    private static final int PASSWORD_LENGTH_CHAR = 58;
    public static final Pattern ARGON_PASSWORD = Pattern.compile("^a\\d+:\\d+:\\d+\\$[^$]+\\$[^$]+$");
    public static final Pattern USERNAME = Pattern.compile("^\\d*[a-zA-Z._-][a-zA-Z.\\d_-]*$");

    private Members() {
    }

    public static boolean checkNames(@Nullable String firstname, @Nullable String surname, GeneratorResponse res) {
        int maxLength = 50;
        if (firstname != null && firstname.length() > 50) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NAME_TOO_LONG, "First name '" + firstname + "' is too long (more than 50 characters).");
            return false;
        }
        if (surname != null && surname.length() > 50) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NAME_TOO_LONG, "Surname '" + surname + "' is too long (more than 50 characters).");
            return false;
        }
        return true;
    }

    public static boolean checkEmailUsername(@Nullable String email, @Nullable String username, @Nullable Member member, boolean admin, Database db, GeneratorResponse res) throws QueryFailedException {
        Member m;
        int maxLength = 100;
        if ("".equals(email) && "".equals(username)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USERNAME_OR_EMAIL_REQUIRED);
            return false;
        }
        if (username != null) {
            if (username.length() > 0) {
                if (username.length() > 100) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USERNAME_TOO_LONG);
                    return false;
                }
                if (!USERNAME.matcher(username).matches()) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.ILLEGAL_USERNAME);
                    return false;
                }
                m = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
                if (!(m == null || member != null && m.getId().equals(member.getId()))) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USER_EXISTS);
                    return false;
                }
            } else if (email == null && (member == null || "No Email".equals(member.getEmail()))) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USERNAME_OR_EMAIL_REQUIRED);
                return false;
            }
        }
        if (email != null) {
            if (email.length() > 0) {
                SecurityConfig sec_config;
                List domains;
                if (email.length() > 100) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.EMAIL_TOO_LONG);
                    return false;
                }
                if (!Emails.isAddress((String)email)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_EMAIL);
                    return false;
                }
                m = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
                if (!(m == null || member != null && m.getId().equals(member.getId()))) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USER_EXISTS);
                    return false;
                }
                if (!admin && !Members.emailMatches(email, domains = (sec_config = OrganizationManager.instance().getSecurityConfig()).getEmailDomains())) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_EMAIL, "This email domain is not allowed by the organization config.");
                    return false;
                }
            } else if (username == null && (member == null || member.getUsername().indexOf(64) >= 0)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USERNAME_OR_EMAIL_REQUIRED);
                return false;
            }
        }
        return true;
    }

    public static boolean emailMatches(String email, List<String> domains) {
        if (domains.isEmpty()) {
            return true;
        }
        String domain = email.substring(email.indexOf(64) + 1).toLowerCase();
        if (domains.contains(domain)) {
            return true;
        }
        while (domain.contains(".")) {
            if (!domains.contains("*." + (domain = domain.substring(domain.indexOf(".") + 1)))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPassword(@Nullable String password, boolean admin, GeneratorResponse res) {
        int maxLength = 100;
        if (password != null) {
            String strength;
            if (password.length() > 100) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.PASSWORD_TOO_LONG);
                return false;
            }
            String string = strength = admin ? "STRONG" : "MEDIUM";
            if (!SecurityUtils.isPasswordAtLeast((String)password, (String)strength)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.PASSWORD_TOO_WEAK);
                return false;
            }
        }
        return true;
    }

    public static @Nullable Member getMember(GeneratorRequest req) throws QueryFailedException {
        String member = req.getParameter((Parameter)StandardParameters.member);
        if (!Strings.isEmpty((String)member)) {
            return MemberRule.getMember((Database)req.getDatabase(), (String)member);
        }
        return req.getMember();
    }

    public static int importMembers(Database db, Transaction tr, String data, boolean createPersonalGroup, @Nullable Group group, @Nullable Role psrole, @Nullable Notification notify, boolean listed, List<MemberDetails> created, List<MemberDetails> existing, List<MemberDetails> failed) throws DatabaseException, IOException, FoundationException {
        String line;
        Group memberProject = GroupRule.getMemberProject((Database)db);
        SecurityConfig sec_config = OrganizationManager.instance().getSecurityConfig();
        List domains = sec_config.getEmailDomains();
        ArrayList<MemberDetails> created_temp = new ArrayList<MemberDetails>();
        ArrayList<MemberDetails> existing_temp = new ArrayList<MemberDetails>();
        ArrayList<MemberDetails> failed_temp = new ArrayList<MemberDetails>();
        ArrayList<MemberDetails> import_temp = new ArrayList<MemberDetails>();
        int totalread = 0;
        BufferedReader in = new BufferedReader(new StringReader(data));
        while ((line = in.readLine()) != null) {
            ++totalread;
            MemberDetails imported = new MemberDetails(line);
            if (imported.errorMessage != null) {
                failed_temp.add(imported);
                continue;
            }
            import_temp.add(new MemberDetails(imported));
            try {
                Members.importMember(db, imported, createPersonalGroup, group, psrole, notify, listed, memberProject, domains, created_temp, existing_temp, failed_temp);
                if (totalread % 100 != 0) continue;
                tr.commitAndStart();
                created.addAll(created_temp);
                failed.addAll(failed_temp);
                existing.addAll(existing_temp);
                created_temp.clear();
                failed_temp.clear();
                existing_temp.clear();
                import_temp.clear();
            }
            catch (Exception ex) {
                LOGGER.warn("Retrying import of " + import_temp.size() + " members: " + ex.getMessage());
                Members.retry(db, tr, import_temp, createPersonalGroup, group, psrole, notify, listed, memberProject, domains, created_temp, existing_temp, failed_temp, created, existing, failed);
                created.addAll(created_temp);
                failed.addAll(failed_temp);
                existing.addAll(existing_temp);
                created_temp.clear();
                failed_temp.clear();
                existing_temp.clear();
                import_temp.clear();
            }
        }
        created.addAll(created_temp);
        failed.addAll(failed_temp);
        existing.addAll(existing_temp);
        return totalread;
    }

    private static void retry(Database db, Transaction tr, List<MemberDetails> import_temp, boolean createPersonalGroup, @Nullable Group group, Role psrole, Notification notify, boolean listed, Group memberProject, List<String> domains, List<MemberDetails> created_temp, List<MemberDetails> existing_temp, List<MemberDetails> failed_temp, List<MemberDetails> created, List<MemberDetails> existing, List<MemberDetails> failed) throws FoundationException, DatabaseException {
        tr.abort();
        tr = new Transaction(db);
        tr.begin();
        created_temp.clear();
        failed_temp.clear();
        existing_temp.clear();
        for (MemberDetails details : import_temp) {
            int create = created_temp.size();
            int exist = existing_temp.size();
            int fail = failed_temp.size();
            try {
                if (!Members.importMember(db, details, createPersonalGroup, group, psrole, notify, listed, memberProject, domains, created_temp, existing_temp, failed_temp)) continue;
                tr.commitAndStart();
            }
            catch (Exception ex) {
                LOGGER.warn("Retrying import of member " + details.username + ", " + details.email + ": " + ex.getMessage());
                tr.abort();
                tr = new Transaction(db);
                tr.begin();
                if (created_temp.size() > create) {
                    created_temp.remove(created_temp.size() - 1);
                }
                if (existing_temp.size() > exist) {
                    existing_temp.remove(existing_temp.size() - 1);
                }
                if (failed_temp.size() > fail) {
                    failed_temp.remove(failed_temp.size() - 1);
                }
                if (!Members.importMember(db, details, createPersonalGroup, group, psrole, notify, listed, memberProject, domains, created_temp, existing_temp, failed_temp)) continue;
                tr.commitAndStart();
            }
        }
    }

    private static boolean importMember(Database db, MemberDetails imported, boolean createPersonalGroup, @Nullable Group group, Role psrole, Notification notify, boolean listed, Group memberProject, List<String> domains, List<MemberDetails> created_temp, List<MemberDetails> existing_temp, List<MemberDetails> failed_temp) throws FoundationException, DatabaseException {
        Member member;
        boolean modifiedSomething = false;
        Member member2 = member = imported.username == null ? null : DatabaseQuery.getMemberByUsername((Database)db, (String)imported.username);
        if (member == null && !imported.email.isEmpty() && !"No Email".equals(imported.email)) {
            member = DatabaseQuery.getMemberByEmail((Database)db, (String)imported.email);
        }
        if (imported.email.isEmpty()) {
            imported.errorMessage = "Email cannot be empty, use \"No Email\" or \"null\" instead";
            failed_temp.add(imported);
        } else if ("No Email".equals(imported.email) && imported.username == null) {
            imported.errorMessage = "Email Address or Username required";
            failed_temp.add(imported);
        } else if (!"No Email".equals(imported.email) && !Emails.isAddress((String)imported.email)) {
            imported.errorMessage = "Email Address invalid";
            failed_temp.add(imported);
        } else if (!(member != null || "No Email".equals(imported.email) || domains.isEmpty() || domains.contains(imported.email.substring(imported.email.indexOf(64) + 1).toLowerCase()))) {
            imported.errorMessage = "Email domain not allowed by organization config";
            failed_temp.add(imported);
        } else if (imported.username != null && (imported.username.indexOf(64) != -1 || imported.username.indexOf(44) != -1)) {
            imported.errorMessage = "Username cannot contain character '@' or ','";
            failed_temp.add(imported);
        } else if (imported.firstname == null || imported.firstname.isEmpty()) {
            imported.errorMessage = "The firstname is required";
            failed_temp.add(imported);
        } else if (imported.surname == null || imported.surname.isEmpty()) {
            imported.errorMessage = "The surname is required";
            failed_temp.add(imported);
        } else if (!MemberRule.isNameValid((String)imported.firstname)) {
            imported.errorMessage = "The firstname is too long";
            failed_temp.add(imported);
        } else if (!MemberRule.isNameValid((String)imported.surname)) {
            imported.errorMessage = "The surname is too long";
            failed_temp.add(imported);
        } else if (member == null && "".equals(imported.password)) {
            imported.errorMessage = "Password must be supplied for new members";
            failed_temp.add(imported);
        } else if (member == null && !imported.isEncodedPassword() && !SecurityUtils.isPasswordAtLeast((String)imported.password, (String)"MEDIUM")) {
            imported.errorMessage = "Password is too weak";
            failed_temp.add(imported);
        } else {
            Group personalProject;
            Group g;
            boolean alreadyInGroup = false;
            if (member == null) {
                member = imported.toMember(Member.create((Database)db));
                member = member.insert(db);
                imported.update(member);
                created_temp.add(imported);
                modifiedSomething = true;
            } else {
                imported.errorMessage = "Member already exists";
                if (group != null) {
                    alreadyInGroup = DatabaseQuery.getMemberForGroupByGroupIdMemberId((Database)db, (Long)group.getId(), (Long)member.getId()) != null;
                    imported.errorMessage = alreadyInGroup ? imported.errorMessage + " and belongs to group " + group.getName() : imported.errorMessage + " and has been added to group " + group.getName();
                }
                imported.update(member);
                existing_temp.add(imported);
            }
            if (createPersonalGroup && (g = GroupRule.createMemberPersonalGroup((Database)db, (Member)member, (Group)(personalProject = GroupRule.createMemberPersonalProject((Database)db, (Member)member, (Group)memberProject)), null)) != null) {
                modifiedSomething = true;
                imported.personalGroupCreated = true;
            }
            if (group != null && !alreadyInGroup) {
                MemberForGroup mfg = MemberForGroup.create((Database)db);
                mfg.setListed(Boolean.valueOf(listed));
                mfg.setNotification(notify.type());
                mfg.setMember(member);
                if (psrole != null) {
                    String editorFlags = psrole.getFlags();
                    if (editorFlags != null) {
                        mfg.setEditorFlags(editorFlags);
                    }
                    mfg.setEditor(Boolean.valueOf(psrole.isEditor()));
                } else {
                    mfg.setEditor(Boolean.FALSE);
                }
                group.addMembersForGroup(mfg);
                if (imported.hasFields()) {
                    MemberGroupDetails mgd = MemberGroupDetails.create((Database)db);
                    imported.populateFields(mgd);
                    mgd = mgd.insert(db);
                    mfg.setMemberGroupDetails(mgd);
                }
                mfg.insert(db);
                modifiedSomething = true;
                imported.addedToGroup = true;
                new UserDetailsManager().remove(member.getId());
            }
        }
        return modifiedSomething;
    }

    public static final class MemberDetails {
        private String firstname;
        private String surname;
        private String email;
        private String username;
        private String password;
        private String[] fields;
        private String errorMessage = null;
        private Long memberid = null;
        private boolean personalGroupCreated = false;
        private boolean addedToGroup = false;

        public MemberDetails(MemberDetails orig) {
            this.firstname = orig.firstname;
            this.surname = orig.surname;
            this.email = orig.email;
            this.username = orig.username;
            this.password = orig.password;
            this.fields = orig.fields;
            this.errorMessage = orig.errorMessage;
            this.memberid = orig.memberid;
            this.personalGroupCreated = orig.personalGroupCreated;
            this.addedToGroup = orig.addedToGroup;
        }

        public MemberDetails(String line) {
            String[] tokens = CSVParser.parse(line);
            if (tokens.length < 3) {
                this.firstname = "";
                this.surname = "";
                this.email = "";
                this.errorMessage = "Invalid data: " + line;
            } else {
                this.firstname = tokens[0].trim();
                this.surname = tokens[1].trim();
                this.email = tokens[2].trim();
                if ("null".equalsIgnoreCase(this.email)) {
                    this.email = "No Email";
                }
            }
            String string = this.username = tokens.length > 3 ? tokens[3].trim() : "";
            if (this.username.equals(this.email)) {
                this.username = "";
            }
            this.password = tokens.length > 4 ? tokens[4].trim() : "";
            this.fields = tokens;
        }

        public void update(Member member) {
            this.memberid = member.getId();
            this.username = member.getUsername();
            this.firstname = member.getFirstName();
            this.surname = member.getSurname();
            this.email = member.getEmail();
        }

        public Member toMember(Member mem) throws FoundationException {
            Date now = new Date();
            mem.setCreated(now);
            mem.setActivated(now);
            mem.setFirstName(this.firstname);
            mem.setSurname(this.surname);
            mem.setEmail(this.email);
            if (this.username.isEmpty()) {
                this.username = this.email;
            }
            mem.setUsername(this.username);
            if (this.isEncodedPassword()) {
                mem.setPassword(this.password);
            } else {
                mem.setPassword(SecurityUtils.encodeAndSaltPassword((String)this.password));
            }
            return mem;
        }

        public boolean isEncodedPassword() {
            return this.password.length() == 58 && this.password.charAt(0) == 's' || ARGON_PASSWORD.matcher(this.password).matches();
        }

        public boolean hasFields() {
            return this.fields.length > 5;
        }

        public void populateFields(MemberGroupDetails mgd) {
            int base = 5;
            int maxNbOfFields = 15;
            int count = Math.min(this.fields.length, 20);
            for (int i = 5; i < count; ++i) {
                String field = this.fields[i];
                mgd.setField(i - 5 + 1, field.trim());
            }
        }

        public void toUniversal(UniversalPrinter out, String status) {
            out.startObject("import");
            out.field("firstname", this.firstname);
            out.field("surname", this.surname);
            if (this.email != null) {
                out.field("email", this.email);
            }
            if (this.username != null) {
                out.field("username", this.username);
            }
            out.field("status", status);
            if (this.memberid != null) {
                out.field("id", this.memberid.longValue());
            }
            if (this.personalGroupCreated) {
                out.field("personal-group-created", true);
            }
            if (this.addedToGroup) {
                out.field("added-to-group", true);
            }
            if (this.errorMessage != null && "error".equals(status)) {
                out.field("error", this.errorMessage);
            }
            out.endObject();
        }

        public void toXML(XMLWriter xml, String elementname) throws IOException {
            xml.openElement(elementname);
            xml.element("firstname", this.firstname);
            xml.element("surname", this.surname);
            if (this.email != null) {
                xml.element("email", this.email);
            }
            if (this.username != null) {
                xml.element("username", this.username);
            }
            if (this.password.length() > 0) {
                xml.element("password", this.password);
            }
            if (this.errorMessage != null) {
                xml.element("errormessage", this.errorMessage);
            }
            if (this.memberid != null) {
                xml.element("id", String.valueOf(this.memberid));
            }
            if (this.personalGroupCreated) {
                xml.element("personal-group-created", "true");
            }
            if (this.addedToGroup) {
                xml.element("added-to-group", "true");
            }
            xml.closeElement();
        }
    }
}

