/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.util.PublicAPI;

@PublicAPI
public enum MemberErrorID implements ErrorID
{
    ILLEGAL_USERNAME(4097, "Username allows letters, numbers, '.', '_', '-', with at least 1 non-number."),
    INVALID_EMAIL(4098, "Invalid email address."),
    NOT_IN_PERSONAL_GROUP(4099, "Cannot add new members to personal groups."),
    USER_EXISTS(4100, "Username/email already in use."),
    NO_MORE_MEMBERS(4101, "No more members allowed."),
    NOT_A_MEMBER(4102, "User is not a member of group."),
    NAME_TOO_LONG(4103, "First name / surname is too long."),
    USERNAME_OR_EMAIL_REQUIRED(4104, "At least one of email/username must be specified."),
    USERNAME_TOO_LONG(4105, "Username is too long."),
    EMAIL_TOO_LONG(4106, "Email is too long."),
    PASSWORD_TOO_LONG(4107, "Password is too long."),
    PASSWORD_REQUIRED(4108, "Password must be specified."),
    ILLEGAL_ROLE(4109, "Specified role is not valid."),
    NO_MATCHING_MEMBER(4110, "No matching member."),
    MEMBER_HAS_NO_EMAIL(4111, "Member has no email."),
    MEMBER_ALREADY_ACTIVE(4112, "Member is already activated."),
    INVALID_ACTIVATION_KEY(4113, "The supplied activation key is invalid."),
    INVALID_MEMBERSHIP_ID(4114, "The supplied membership ID is invalid."),
    MEMBER_ALREADY_ACCEPTED(4115, "Member has already accepted the invitation."),
    CONTRADICTORY_DEREGISTRATION(4116, "Member cannot deregister and register or change role at the same time."),
    PASSWORD_TOO_WEAK(4117, "Password is not strong enough"),
    INVALID_CREDENTIALS(4118, "Password cannot be equal to username."),
    INCORRECT_PASSWORD(4119, "Incorrect password."),
    API_ACCOUNT(4120, "Cannot reset password for an API account."),
    RESET_PASSWORD_LOCKED(4121, "Account is locked due to incorrect security key or date."),
    USERNAME_EMAIL_DO_NOT_MATCH(4122, "The username and email are not from the same member."),
    FIRSTNAME_SURNAME_REQUIRED(4123, "The first name and surname are required."),
    EMAIL_REQUIRED(4124, "Email is required."),
    MEMBER_NOT_IN_GROUP(4130, "The member does not belong to the group."),
    GROUP_NOT_ALLOWED(4131, "The group is not allowed."),
    MEMBER_ALREADY_IN_GROUP(4133, "The member already belongs to the group."),
    NO_INVITATION(4134, "The member has not been invited to the group."),
    INVALID_MEMBER_ID(4135, "The supplied member ID is invalid."),
    MEMBER_REQUIRED(4136, "A member is required."),
    NOT_LOGGED_IN(4137, "A member is not logged in."),
    MEMBER_NOT_FOUND(4138, "Member not found."),
    TOKEN_INVALID(4138, "Token is invalid or has expired."),
    TOKEN_EXPIRED(4139, "Token has expired."),
    AT_LEAST_1_ADMINISTRATOR(4140, "There must be at least one administrator left."),
    NO_MEMBER_DATA_FOUND(4141, "No member data found"),
    MEMBER_DATA_QUOTA_REACHED(4142, "Too many member data types"),
    MEMBER_DATA_TOO_LARGE(4143, "Member data exceeds maximum length"),
    MEMBER_DATA_UNSUPPORTED_MEDIA_TYPE(4144, "Unsupported media type for member data"),
    MEMBER_DATA_IMAGE_ERROR(4145, "Unable to process image"),
    INVALID_MEMBER_DATA_PATH(4144, "Member data must match `[name].[extension]`"),
    MEMBER_DATA_TOO_LONG(4144, "Member data should not exceed 250 characters"),
    MEMBER_DATA_PRECONDITION_FAILED(4145, "Member data has been modified since update attempt"),
    MEMBER_DATA_INVALID(4146, "Member data is invalid"),
    EXTERNAL_EMAIL_DOMAIN(4147, "Email domain from external only domain."),
    UNABLE_TO_SEND_ACTIVATION(24577, "Unable to send the activation email."),
    UNABLE_TO_SEND_EMAIL_CONFIRM(24578, "Unable to send the email address change confirmation."),
    UNABLE_TO_SEND_PASSWORD_CONFIRM(24579, "Unable to send the password change confirmation."),
    UNABLE_TO_CONFIGURE_MEMBER_DETAILS(24580, "Unable to configure the member details."),
    NO_MODERATOR_EMAIL(24581, "Group has no moderator with an email address.");

    private final int _id;
    private final String _message;

    private MemberErrorID(int id, String message) {
        if (id < 0) {
            throw new IndexOutOfBoundsException("Error ID must be >= 0");
        }
        this._id = id;
        this._message = message;
    }

    public int id() {
        return this._id;
    }

    public String message() {
        return this._message;
    }
}

