/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mfa.MFA;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import java.io.IOException;
import java.util.List;

@Requires(database=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListAuthenticators
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Member member = req.getMember();
        return member != null ? new ViewMemberCheck(member) : new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Member member = req.getMember();
        if (member == null) {
            member = req.getAuthenticatedMember();
        }
        assert (member != null);
        Database db = req.getDatabase();
        List authenticators = Authenticators.listAuthenticatorsForMember((Database)db, (long)member.getId());
        List supportedTypes = MFA.getSupportedTypes();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("authenticators");
        out.field("supported", String.join((CharSequence)",", supportedTypes));
        out.startCollection("authenticators", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Authenticator authenticator : authenticators) {
            out.writeAuthenticator(authenticator);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

